/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.main.VarFinder;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestVarFinder
extends BaseTest {
    @Test
    public void varfind_01_1() {
        TestVarFinder.varfindFixed("(bgp (?s <p> <o>))", "s");
    }

    @Test
    public void varfind_01_2() {
        TestVarFinder.varfindOpt("(bgp (?s <p> <o>))", new String[0]);
    }

    @Test
    public void varfind_01_3() {
        TestVarFinder.varfindFilter("(bgp (?s <p> <o>))", new String[0]);
    }

    @Test
    public void varfind_02_1() {
        TestVarFinder.varfindFixed("(graph ?g (bgp (?s <p> <o>)))", "s", "g");
    }

    @Test
    public void varfind_02_2() {
        TestVarFinder.varfindOpt("(graph ?g (bgp (?s <p> <o>)))", new String[0]);
    }

    @Test
    public void varfind_02_3() {
        TestVarFinder.varfindFilter("(graph ?g (bgp (?s <p> <o>)))", new String[0]);
    }

    @Test
    public void varfind_03_1() {
        TestVarFinder.varfindFixed("(filter (?s) (bgp (?s <p> <o>)))", "s");
    }

    @Test
    public void varfind_03_2() {
        TestVarFinder.varfindOpt("(filter (?s) (bgp (?s <p> <o>)))", new String[0]);
    }

    @Test
    public void varfind_03_3() {
        TestVarFinder.varfindFilter("(filter (?s) (bgp (?s <p> <o>)))", "s");
    }

    @Test
    public void varfind_04_1() {
        TestVarFinder.varfindFixed("(leftjoin (bgp (?x <q> <v>)) (filter (?s) (bgp (?s <p> <o>))))", "x");
    }

    @Test
    public void varfind_04_2() {
        TestVarFinder.varfindOpt("(leftjoin (bgp (?x <q> <v>)) (filter (?s) (bgp (?s <p> <o>))))", "s");
    }

    @Test
    public void varfind_04_3() {
        TestVarFinder.varfindFilter("(leftjoin (bgp (?x <q> <v>)) (filter (?s) (bgp (?s <p> <o>))))", "s");
    }

    private static void varfindFixed(String string, String ... vars) {
        TestVarFinder.varfind(string, vars, null, null);
    }

    private static void varfindOpt(String string, String ... vars) {
        TestVarFinder.varfind(string, null, vars, null);
    }

    private static void varfindFilter(String string, String ... vars) {
        TestVarFinder.varfind(string, null, null, vars);
    }

    private static void varfind(String string, String[] varsFixed, String[] varsOpt, String[] varsFilter) {
        Op op = SSE.parseOp((String)string);
        VarFinder vf = new VarFinder(op);
        if (varsFixed != null) {
            TestVarFinder.check(varsFixed, vf.getFixed());
        }
        if (varsOpt != null) {
            TestVarFinder.check(varsOpt, vf.getOpt());
        }
        if (varsFilter != null) {
            TestVarFinder.check(varsFilter, vf.getFilter());
        }
    }

    private static void check(String[] varsExpected, Set<Var> varsFound) {
        Var[] vars = new Var[varsExpected.length];
        for (int i = 0; i < varsExpected.length; ++i) {
            Var v;
            vars[i] = v = Var.alloc((String)varsExpected[i]);
        }
        List<Var> varList = Arrays.asList(vars);
        HashSet<Var> varSet = new HashSet<Var>();
        varSet.addAll(varList);
        TestVarFinder.assertEquals(varSet, varsFound);
    }
}

