/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import java.util.Map;
import org.apache.jena.atlas.lib.StrUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestOpAsQuery {
    @Test
    public void testCountStar() {
        Query[] result = this.checkQuery("select (count(*) as ?cs) { ?s ?p ?o }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testCountGroup() {
        Query[] result = this.checkQuery("select (count(?p) as ?cp) { ?s ?p ?o } group by ?s");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testCountGroupAs() {
        Query[] result = this.checkQuery("select (count(?p) as ?cp) { ?s ?p ?o }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testDoubleCount() {
        Query[] result = this.checkQuery("select (count(?s) as ?sc) (count(?p) as ?pc) { ?s ?p ?o }");
        Assert.assertEquals((long)2L, (long)result[1].getResultVars().size());
        Assert.assertTrue((boolean)result[1].getResultVars().contains("sc"));
        Assert.assertTrue((boolean)result[1].getResultVars().contains("pc"));
    }

    @Test
    public void testGroupWithExpression() {
        Query[] result = this.checkQuery("SELECT (sample(?a) + 1 AS ?c) {} GROUP BY ?x");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testProject1() {
        Query[] result = this.checkQuery("SELECT (?x + 1 AS ?c) {}");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testProject2() {
        Query[] result = this.checkQuery("SELECT (?x + 1 AS ?c) ?d {}");
        Assert.assertEquals((long)2L, (long)result[1].getResultVars().size());
        Assert.assertTrue((boolean)result[1].getResultVars().contains("c"));
        Assert.assertTrue((boolean)result[1].getResultVars().contains("d"));
    }

    @Test
    public void testNestedBind() {
        Query[] result = this.checkQuery("SELECT ?c { { } UNION { BIND(?x + 1 AS ?c) } }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testNestedProject() {
        Query[] result = this.checkQuery("SELECT (?x + 1 AS ?c) { { } UNION { } }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testGroupExpression() {
        Query[] result = this.checkQuery("SELECT ?z { } GROUP BY (?x + ?y AS ?z)");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testNestedProjectWithGroup() {
        Query[] result = this.checkQuery("SELECT (SAMPLE(?c) as ?s) { {} UNION {BIND(?x + 1 AS ?c)} } GROUP BY ?x");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testQuadPatternInDefaultGraph() {
        Query[] result = this.checkQuadQuery("SELECT * WHERE { ?s a ?type }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testGraphClauseUri() {
        Query[] result = this.checkQuery("SELECT * WHERE { GRAPH <http://example> { ?s a ?type } }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testGraphClauseComplex() {
        Query[] result = this.checkQuery("SELECT * WHERE { GRAPH <http://example> { ?s a ?type . OPTIONAL { ?s <http://label> ?label } } }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testQuadPatternInGraph() {
        Query[] result = this.checkQuadQuery("SELECT * WHERE { GRAPH <http://example> { ?s a ?type } }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testQuadPatternInGraphComplex01() {
        Query[] result = this.checkQuadQuery("SELECT * WHERE { GRAPH <http://example> { ?s a ?type . OPTIONAL { ?s <http://label> ?label } } }");
        Assert.assertFalse((boolean)result[0].equals(result[1]));
    }

    @Test
    public void testQuadPatternInGraphComplex02() {
        Query[] result = this.checkQuadQuery("SELECT * WHERE { GRAPH <http://example> { ?s a ?type } OPTIONAL { GRAPH <http://example> { ?s <http://label> ?label } } }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testExtend1() {
        Query[] result = this.checkQuery("SELECT * WHERE { ?s ?p ?o . BIND(?o AS ?x) }");
        Assert.assertNotEquals((Object)result[0], (Object)result[1]);
        Assert.assertTrue((boolean)result[1].getResultVars().contains("x"));
    }

    @Test
    public void testExtend2() {
        Query[] result = this.checkQuery("SELECT * WHERE { GRAPH ?g { ?s ?p ?o . BIND(?o AS ?x) } }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
    }

    @Test
    public void testExtend3() {
        String query = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://www.cipe.accamargo.org.br/ontologias/h2tc.owl#>", "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>", "PREFIX mylib: <java:dateadd.lib.pkgfor.arq.>", "", "SELECT ?yearmonth ( count(?document) as ?total )", "{", "    ?document a :Document;", "   :documentDateOfCreation ?date ;", "   :documentType \"exam results\" .", "    BIND( mylib:DateFormat( xsd:string(?date), \"yyyy-MM\" ) as ?yearmonth )", "} group by ?yearmonth"});
        this.checkQueryParseable(query, true);
    }

    @Test
    public void testExtend4() {
        String query = "SELECT ?key (COUNT(?member) AS ?total) WHERE { ?s ?p ?o . BIND(LCASE(?o) AS ?key) } GROUP BY ?key";
        this.checkQueryParseable(query, true);
    }

    @Test
    public void testExtendInService() {
        Query[] result = this.checkQuery("SELECT * WHERE { SERVICE <http://example/endpoint> { ?s ?p ?o . BIND(?o AS ?x) } }");
        Assert.assertEquals((Object)result[0], (Object)result[1]);
        Assert.assertTrue((boolean)result[1].toString().contains("BIND"));
    }

    @Test
    public void testSubQuery1() {
        String query = "SELECT ?s WHERE { { SELECT ?s ?p WHERE { ?s ?p ?o } } }";
        this.checkQueryParseable(query, true);
    }

    @Test
    public void testSubQuery2() {
        String query = "SELECT ?s ?x WHERE { { SELECT ?s ?p WHERE { ?s ?p ?o } } { SELECT ?x WHERE { ?x ?p ?o } } }";
        this.checkQueryParseable(query, false);
    }

    @Test
    public void testSubQuery3() {
        String query = "SELECT * WHERE { { SELECT ?s ?p WHERE { ?s ?p ?o } } { SELECT ?x WHERE { ?x ?p ?o } } }";
        this.checkQueryNonRecoverable(query);
    }

    @Test
    public void testAggregatesInSubQuery1() {
        String query = "SELECT ?key ?agg WHERE { { SELECT ?key (COUNT(*) AS ?agg) { ?key ?p ?o } GROUP BY ?key } }";
        this.checkQueryParseable(query, true);
    }

    @Test
    public void testAggregatesInSubQuery2() {
        String query = "SELECT * WHERE { { SELECT ?key (COUNT(*) AS ?agg) { ?key ?p ?o } GROUP BY ?key } }";
        this.checkQueryParseable(query, false);
    }

    @Test
    public void testAggregatesInSubQuery3() {
        String queryString = "PREFIX dcterms: <http://purl.org/dc/terms/> \nPREFIX dbpedia: <http://dbpedia.org/resource/> \nSELECT ?num_of_holidays ?celebrate_Chinese_New_Year WHERE { \n{SELECT ?country_cat (COUNT(?holiday) as ?num_of_holidays) \nWHERE {?country_cat <http://www.w3.org/2004/02/skos/core#broader> <http://dbpedia.org/resource/Category:Public_holidays_by_country>. \n?holiday dcterms:subject ?country_cat \n}GROUP by ?country_cat \n} \n{ \nSELECT ?country_cat (COUNT(?holiday) as ?celebrate_Chinese_New_Year) \nWHERE { \n?country_cat <http://www.w3.org/2004/02/skos/core#broader> <http://dbpedia.org/resource/Category:Public_holidays_by_country>. \n?holiday dcterms:subject ?country_cat \nFILTER(?holiday=\"http://dbpedia.org/resource/Lunar_New_Year's_Day\") \n}GROUP by ?country_cat \n} \n}\n";
        this.checkQuadQuery(queryString);
    }

    @Test
    public void testPathExpressions1() {
        String query = "PREFIX : <http://example/> SELECT * { ?s :p* ?o . ?x :r 123 . }";
        Query[] r = this.checkQueryParseable(query, false);
    }

    @Test
    public void testPathExpressions2() {
        String query = "PREFIX : <http://example/> SELECT * { ?s :p*/:q ?o . ?x :r 123 . }";
        Query[] r = this.checkQueryParseable(query, false);
    }

    @Test
    public void testMinus1() {
        String query = "PREFIX : <http://example/> SELECT * { ?s :p ?o MINUS { ?s :q ?v .FILTER(?v<5) } }";
        Query[] r = this.checkQueryParseable(query, true);
    }

    @Test
    public void testMinus2() {
        String query = "PREFIX : <http://example/> SELECT * { ?s :p ?o OPTIONAL { ?s :x ?2 } MINUS { ?s :q ?v .FILTER(?v<5) } }";
        Query[] r = this.checkQueryParseable(query, false);
    }

    public Query[] checkQuery(String query) {
        Query orig = QueryFactory.create((String)query, (Syntax)Syntax.syntaxSPARQL_11);
        Op toReconstruct = Algebra.compile((Query)orig);
        Query got = OpAsQuery.asQuery((Op)toReconstruct);
        Query[] r = new Query[]{orig, got};
        return r;
    }

    public Query[] checkQuadQuery(String query) {
        Query orig = QueryFactory.create((String)query, (Syntax)Syntax.syntaxSPARQL_11);
        Op toReconstruct = Algebra.compile((Query)orig);
        toReconstruct = Algebra.toQuadForm((Op)toReconstruct);
        Query got = OpAsQuery.asQuery((Op)toReconstruct);
        Query[] r = new Query[]{orig, got};
        return r;
    }

    public Query[] checkQueryParseable(String query, boolean expectEquals) {
        Query[] r = this.checkQuery(query);
        this.stripNamespacesAndBase(r[0]);
        this.stripNamespacesAndBase(r[1]);
        if (expectEquals) {
            Assert.assertEquals((Object)r[0], (Object)r[1]);
        } else {
            Assert.assertNotEquals((Object)r[0], (Object)r[1]);
            Op a1 = Algebra.compile((Query)r[0]);
            Op a2 = Algebra.compile((Query)r[1]);
            Assert.assertEquals((Object)a1, (Object)a2);
        }
        String query2 = r[1].toString();
        Query q = QueryFactory.create((String)query2);
        return r;
    }

    public Query[] checkQueryNonRecoverable(String query) {
        Query[] r = this.checkQuery(query);
        this.stripNamespacesAndBase(r[0]);
        this.stripNamespacesAndBase(r[1]);
        Assert.assertNotEquals((Object)r[0], (Object)r[1]);
        Op a1 = Algebra.compile((Query)r[0]);
        Op a2 = Algebra.compile((Query)r[1]);
        Assert.assertNotEquals((Object)a1, (Object)a2);
        return r;
    }

    protected void stripNamespacesAndBase(Query q) {
        Map prefixes = q.getPrefixMapping().getNsPrefixMap();
        for (String prefix : prefixes.keySet()) {
            q.getPrefixMapping().removeNsPrefix(prefix);
        }
        q.setBaseURI((String)null);
    }
}

