/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph ;
import com.hp.hpl.jena.graph.Node ;
import com.hp.hpl.jena.sparql.core.DatasetGraph ;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory ;
import com.hp.hpl.jena.sparql.core.DatasetGraphViewGraphs ;

/** Test using a view-generating dataset */  
public class TestGraphOverDatasetMem extends AbstractTestGraphOverDataset
{
    @Override
    protected DatasetGraph createBaseDSG()
    { 
        DatasetGraph dsg = DatasetGraphFactory.createMem() ;
        return new DatasetGraphViewGraphs(dsg) ;
    }
    
    @Override
    protected Graph makeDefaultGraph(DatasetGraph dsg)
    {
        return dsg.getDefaultGraph() ;
    }

    @Override
    protected Graph makeNamedGraph(DatasetGraph dsg, Node gn)
    {
        return dsg.getGraph(gn) ;
    }
}
