/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import java.io.IOException;
import java.io.Writer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.out.EscapeStr;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.out.NodeFormatterBase;

public class NodeFormatterNT
extends NodeFormatterBase {
    private final EscapeStr escapeProc;

    public NodeFormatterNT() {
        this(true);
    }

    protected NodeFormatterNT(boolean asciiOnly) {
        this.escapeProc = new EscapeStr(asciiOnly);
    }

    @Override
    public void formatURI(Writer w, String uriStr) {
        try {
            w.write(60);
            w.write(uriStr);
            w.write(62);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    @Override
    public void formatVar(Writer w, String name) {
        try {
            w.write(63);
            w.write(name);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    @Override
    public void formatBNode(Writer w, String label) {
        try {
            w.write("_:");
            String lab = NodeFmtLib.encodeBNodeLabel(label);
            w.write(lab);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    @Override
    public void formatLitString(Writer w, String lex) {
        try {
            this.writeEscaped(w, lex);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private void writeEscaped(Writer w, String lex) throws IOException {
        w.write(34);
        this.escapeProc.writeStr(w, lex);
        w.write(34);
    }

    @Override
    public void formatLitLang(Writer w, String lex, String langTag) {
        try {
            this.writeEscaped(w, lex);
            w.write(64);
            w.write(langTag);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    @Override
    public void formatLitDT(Writer w, String lex, String datatypeURI) {
        try {
            this.writeEscaped(w, lex);
            w.write("^^");
            this.formatURI(w, datatypeURI);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }
}

