/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;

public class RDFReaderRIOT
implements RDFReader {
    private final String base;
    private final String hintlang;
    Context context = new Context();
    RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    public RDFReaderRIOT() {
        this.base = "org.apache.jena.lang.generic";
        this.hintlang = null;
    }

    public RDFReaderRIOT(String lang) {
        this.base = "org.apache.jena.lang." + lang.toLowerCase(Locale.US);
        this.hintlang = lang;
    }

    public void read(Model model, Reader r, String base) {
        RDFDataMgr.read(model, r, base, RDFLanguages.nameToLang(this.hintlang));
    }

    public void read(Model model, InputStream r, String base) {
        RDFDataMgr.read(model, r, base, RDFLanguages.nameToLang(this.hintlang));
    }

    public void read(Model model, String url) {
        RDFDataMgr.read(model, url, RDFLanguages.nameToLang(this.hintlang));
    }

    public Object setProperty(String propName, Object propValue) {
        Symbol sym = Symbol.create(this.base + propName);
        Object oldObj = this.context.get(sym);
        return oldObj;
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }
}

