/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.mgt.ARQMgt;
import com.hp.hpl.jena.sparql.mgt.SystemInfo;
import org.apache.jena.riot.IO_Jena;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.SysRIOT;

public class RIOT {
    public static final String riotIRI = "http://jena.apache.org/#riot";
    public static final String NAME = "RIOT";
    public static final String PATH = "org.apache.jena.riot";
    public static final String VERSION = "ARQ/" + ARQ.VERSION;
    public static final String BUILD_DATE = ARQ.BUILD_DATE;
    private static boolean initialized = false;
    private static boolean registered = false;

    public static void setStrictMode(boolean state) {
        SysRIOT.strictMode = state;
        SysRIOT.StrictXSDLexicialForms = state;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        RDFLanguages.init();
        RDFParserRegistry.init();
        IO_Jena.wireIntoJena();
    }

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        String NS = PATH;
        SystemInfo sysInfo2 = new SystemInfo(riotIRI, VERSION, BUILD_DATE);
        ARQMgt.register(NS + ".system:type=SystemInfo", sysInfo2);
        SystemARQ.registerSubSystem(sysInfo2);
    }
}

