/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json.io.parserjavacc;

import com.hp.hpl.jena.n3.turtle.parser.TokenMgrError;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.json.JsonParseException;
import org.apache.jena.atlas.json.io.JSONHandler;
import org.apache.jena.atlas.json.io.parserjavacc.javacc.JSON_Parser;
import org.apache.jena.atlas.json.io.parserjavacc.javacc.ParseException;

public class JSONParserJavaCC {
    public static void parse(InputStream input, JSONHandler handler) {
        JSON_Parser p = new JSON_Parser(input);
        JSONParserJavaCC.parse(p, handler);
    }

    public static void parse(Reader reader, JSONHandler handler) {
        JSON_Parser p = new JSON_Parser(reader);
        JSONParserJavaCC.parse(p, handler);
    }

    private static void parse(JSON_Parser p, JSONHandler handler) {
        p.setHandler(handler);
        try {
            p.unit();
        }
        catch (ParseException ex) {
            throw new JsonParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = p.token.endColumn;
            int line = p.token.endLine;
            throw new JsonParseException(tErr.getMessage(), line, col);
        }
    }

    public static void parseAny(InputStream input, JSONHandler handler) {
        JSON_Parser p = new JSON_Parser(input);
        JSONParserJavaCC.parseAny(p, handler);
    }

    public static void parseAny(Reader reader, JSONHandler handler) {
        JSON_Parser p = new JSON_Parser(reader);
        JSONParserJavaCC.parseAny(p, handler);
    }

    private static void parseAny(JSON_Parser p, JSONHandler handler) {
        p.setHandler(handler);
        try {
            p.any();
        }
        catch (ParseException ex) {
            throw new JsonParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = p.token.endColumn;
            int line = p.token.endLine;
            throw new JsonParseException(tErr.getMessage(), line, col);
        }
    }
}

