/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.lang.ParserARQ;
import com.hp.hpl.jena.sparql.lang.ParserSPARQL10;
import com.hp.hpl.jena.sparql.lang.ParserSPARQL11;
import com.hp.hpl.jena.sparql.lang.SPARQLParser;
import com.hp.hpl.jena.sparql.lang.SPARQLParserFactory;
import java.util.HashMap;
import java.util.Map;

public class SPARQLParserRegistry {
    Map<Syntax, SPARQLParserFactory> factories = new HashMap<Syntax, SPARQLParserFactory>();
    static SPARQLParserRegistry registry = null;

    public static synchronized SPARQLParserRegistry get() {
        if (registry == null) {
            SPARQLParserRegistry.init();
        }
        return registry;
    }

    private SPARQLParserRegistry() {
    }

    private static synchronized void init() {
        SPARQLParserRegistry reg = new SPARQLParserRegistry();
        reg.add(Syntax.syntaxSPARQL_10, new SPARQLParserFactory(){

            @Override
            public boolean accept(Syntax syntax) {
                return Syntax.syntaxSPARQL_10.equals(syntax);
            }

            @Override
            public SPARQLParser create(Syntax syntax) {
                return new ParserSPARQL10();
            }
        });
        reg.add(Syntax.syntaxSPARQL_11, new SPARQLParserFactory(){

            @Override
            public boolean accept(Syntax syntax) {
                return Syntax.syntaxSPARQL_11.equals(syntax);
            }

            @Override
            public SPARQLParser create(Syntax syntax) {
                return new ParserSPARQL11();
            }
        });
        reg.add(Syntax.syntaxARQ, new SPARQLParserFactory(){

            @Override
            public boolean accept(Syntax syntax) {
                return Syntax.syntaxARQ.equals(syntax);
            }

            @Override
            public SPARQLParser create(Syntax syntax) {
                return new ParserARQ();
            }
        });
        registry = reg;
    }

    public static SPARQLParserFactory findFactory(Syntax syntax) {
        return SPARQLParserRegistry.get().getFactory(syntax);
    }

    public static SPARQLParser parser(Syntax syntax) {
        return SPARQLParserRegistry.get().createParser(syntax);
    }

    public SPARQLParserFactory getFactory(Syntax syntax) {
        return this.factories.get(syntax);
    }

    public SPARQLParser createParser(Syntax syntax) {
        SPARQLParserFactory f = this.getFactory(syntax);
        return f != null ? f.create(syntax) : null;
    }

    public static void addFactory(Syntax syntax, SPARQLParserFactory f) {
        SPARQLParserRegistry.get().add(syntax, f);
    }

    public void add(Syntax syntax, SPARQLParserFactory f) {
        if (!f.accept(syntax)) {
            throw new IllegalArgumentException("The given parser factory does not accept the specified syntax.");
        }
        this.factories.put(syntax, f);
    }

    public static void removeFactory(Syntax syntax) {
        SPARQLParserRegistry.get().remove(syntax);
    }

    public void remove(Syntax syntax) {
        this.factories.remove(syntax);
    }

    public static boolean containsParserFactory(Syntax syntax) {
        return SPARQLParserRegistry.get().containsFactory(syntax);
    }

    public boolean containsFactory(Syntax syntax) {
        return this.factories.containsKey(syntax);
    }
}

