/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.ExprEvalTypeException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.ValueSpaceClassification;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public class NodeValueOps {
    private static final String dtXSDdateTimeStamp = "http://www.w3.org/2001/XMLSchema#dateTimeStamp";
    private static final String dtXSDdayTimeDuration = "http://www.w3.org/2001/XMLSchema#dayTimeDuration";
    private static final String dtXSDyearMonthDuration = "http://www.w3.org/2001/XMLSchema#yearMonthDuration";

    public static NodeValue additionNV(NodeValue nv1, NodeValue nv2) {
        ValueSpaceClassification vs1 = nv1.getValueSpace();
        ValueSpaceClassification vs2 = nv2.getValueSpace();
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_NUM) && vs2.equals((Object)ValueSpaceClassification.VSPACE_NUM)) {
            return XSDFuncOp.numAdd(nv1, nv2);
        }
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_STRING) && vs2.equals((Object)ValueSpaceClassification.VSPACE_STRING)) {
            return NodeValue.makeString(nv1.asString() + nv2.asString());
        }
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_DURATION) && vs2.equals((Object)ValueSpaceClassification.VSPACE_DURATION)) {
            boolean isDTDur = dtXSDdayTimeDuration.equals(nv1.getDatatypeURI()) && dtXSDdayTimeDuration.equals(nv2.getDatatypeURI());
            boolean isYMDur = dtXSDyearMonthDuration.equals(nv1.getDatatypeURI()) && dtXSDyearMonthDuration.equals(nv2.getDatatypeURI());
            Duration d3 = nv1.getDuration().add(nv2.getDuration());
            String lex = d3.toString();
            Node n = isDTDur ? NodeFactory.createLiteralNode(lex, null, dtXSDdayTimeDuration) : (isYMDur ? NodeFactory.createLiteralNode(lex, null, dtXSDyearMonthDuration) : Node.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDduration));
            return NodeValue.makeNodeDuration(d3, n);
        }
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_DATETIME) && vs2.equals((Object)ValueSpaceClassification.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_add(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeDateTime(result);
            return r;
        }
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_DATE) && vs2.equals((Object)ValueSpaceClassification.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_add(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeDate(result);
            return r;
        }
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_TIME) && vs2.equals((Object)ValueSpaceClassification.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_add(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeNode(result.toXMLFormat(), XSDDatatype.XSDtime);
            return r;
        }
        if (NodeValueOps.isDT(vs2) && vs1.equals((Object)ValueSpaceClassification.VSPACE_DURATION)) {
            return NodeValueOps.additionNV(nv2, nv1);
        }
        throw new ExprEvalTypeException("Operator '+' : Undefined addition: " + nv1 + " and " + nv2);
    }

    public static NodeValue subtractionNV(NodeValue nv1, NodeValue nv2) {
        ValueSpaceClassification vs1 = nv1.getValueSpace();
        ValueSpaceClassification vs2 = nv2.getValueSpace();
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_NUM) && vs2.equals((Object)ValueSpaceClassification.VSPACE_NUM)) {
            return XSDFuncOp.numSubtract(nv1, nv2);
        }
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_DURATION) && vs2.equals((Object)ValueSpaceClassification.VSPACE_DURATION)) {
            boolean isDTDur = dtXSDdayTimeDuration.equals(nv1.getDatatypeURI()) && dtXSDdayTimeDuration.equals(nv2.getDatatypeURI());
            boolean isYMDur = dtXSDyearMonthDuration.equals(nv1.getDatatypeURI()) && dtXSDyearMonthDuration.equals(nv2.getDatatypeURI());
            Duration d3 = nv1.getDuration().subtract(nv2.getDuration());
            String lex = d3.toString();
            Node n = isDTDur ? NodeFactory.createLiteralNode(lex, null, dtXSDdayTimeDuration) : (isYMDur ? NodeFactory.createLiteralNode(lex, null, dtXSDyearMonthDuration) : Node.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDduration));
            return NodeValue.makeNodeDuration(d3, n);
        }
        if (NodeValueOps.isDT(vs1) && NodeValueOps.isDT(vs2)) {
            boolean isDef2;
            XMLGregorianCalendar cal1 = nv1.getDateTime();
            XMLGregorianCalendar cal2 = nv2.getDateTime();
            boolean isDef1 = cal1.getTimezone() == Integer.MIN_VALUE;
            boolean bl = isDef2 = cal2.getTimezone() == Integer.MIN_VALUE;
            if (isDef1 && !isDef2 || !isDef1 && isDef2) {
                throw new ExprEvalTypeException("Operator '-': can't substract timezone/non-timezone values");
            }
            return NodeValue.makeDuration(NodeValueOps.xsd_substract(cal1, cal2));
        }
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_DATETIME) && vs2.equals((Object)ValueSpaceClassification.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_subtract(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeDateTime(result);
            return r;
        }
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_DATE) && vs2.equals((Object)ValueSpaceClassification.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_subtract(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeDate(result);
            return r;
        }
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_TIME) && vs2.equals((Object)ValueSpaceClassification.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_subtract(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeNode(result.toXMLFormat(), XSDDatatype.XSDtime);
            return r;
        }
        throw new ExprEvalTypeException("Operator '-' : Undefined subtraction: " + nv1 + " and " + nv2);
    }

    public static NodeValue multiplicationNV(NodeValue nv1, NodeValue nv2) {
        ValueSpaceClassification vs1 = nv1.getValueSpace();
        ValueSpaceClassification vs2 = nv2.getValueSpace();
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_NUM) && vs2.equals((Object)ValueSpaceClassification.VSPACE_NUM)) {
            return XSDFuncOp.numMultiply(nv1, nv2);
        }
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_DURATION) && vs2.equals((Object)ValueSpaceClassification.VSPACE_NUM)) {
            Duration dur = nv1.getDuration();
            boolean valid = XSDFuncOp.isDayTime(dur);
            if (!valid) {
                throw new ExprEvalTypeException("Operator '*': only dayTime duration.  Got: " + nv1);
            }
            BigDecimal dec = nv2.getDecimal();
            Duration r = dur.multiply(dec);
            Node n = NodeFactory.createLiteralNode(r.toString(), null, dtXSDdayTimeDuration);
            return NodeValue.makeNodeDuration(r, n);
        }
        throw new ExprEvalTypeException("Operator '*' : Undefined multiply: " + nv1 + " and " + nv2);
    }

    public static NodeValue divisionNV(NodeValue nv1, NodeValue nv2) {
        ValueSpaceClassification vs1 = nv1.getValueSpace();
        ValueSpaceClassification vs2 = nv2.getValueSpace();
        if (vs1.equals((Object)ValueSpaceClassification.VSPACE_NUM) && vs2.equals((Object)ValueSpaceClassification.VSPACE_NUM)) {
            return XSDFuncOp.numDivide(nv1, nv2);
        }
        throw new ExprEvalTypeException("Operator '/' : Undefined division: " + nv1 + " and " + nv2);
    }

    private static boolean isDT(ValueSpaceClassification vs) {
        switch (vs) {
            case VSPACE_DATETIME: 
            case VSPACE_DATE: 
            case VSPACE_TIME: 
            case VSPACE_G_YEAR: 
            case VSPACE_G_YEARMONTH: 
            case VSPACE_G_MONTHDAY: 
            case VSPACE_G_MONTH: 
            case VSPACE_G_DAY: {
                return true;
            }
        }
        return false;
    }

    private static XMLGregorianCalendar xsd_add(XMLGregorianCalendar cal, Duration duration) {
        XMLGregorianCalendar result = (XMLGregorianCalendar)cal.clone();
        result.add(duration);
        return result;
    }

    private static XMLGregorianCalendar xsd_subtract(XMLGregorianCalendar cal, Duration duration) {
        return NodeValueOps.xsd_add(cal, duration.negate());
    }

    private static Duration xsd_substract(XMLGregorianCalendar cal1, XMLGregorianCalendar cal2) {
        GregorianCalendar gcal1 = cal1.toGregorianCalendar();
        GregorianCalendar gcal2 = cal2.toGregorianCalendar();
        long x1 = gcal1.getTimeInMillis();
        long x2 = gcal2.getTimeInMillis();
        return NodeValue.xmlDatatypeFactory.newDuration(x1 - x2);
    }
}

