/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.domain;

import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.packet.domain.AutoValue_Device;
import org.jclouds.packet.domain.AutoValue_Device_CreateDevice;
import org.jclouds.packet.domain.Facility;
import org.jclouds.packet.domain.Href;
import org.jclouds.packet.domain.IpAddress;
import org.jclouds.packet.domain.OperatingSystem;
import org.jclouds.packet.domain.Plan;
import org.jclouds.packet.domain.ProvisioningEvent;

public abstract class Device {
    public abstract String id();

    public abstract String shortId();

    public abstract String hostname();

    @Nullable
    public abstract String description();

    public abstract State state();

    public abstract List<String> tags();

    public abstract String billingCycle();

    public abstract String user();

    public abstract String iqn();

    public abstract Boolean locked();

    public abstract String bondingMode();

    public abstract Date createdAt();

    public abstract Date updatedAt();

    public abstract OperatingSystem operatingSystem();

    public abstract Facility facility();

    public abstract Href project();

    public abstract List<Href> sshKeys();

    public abstract Href projectLite();

    public abstract List<Object> volumes();

    public abstract List<IpAddress> ipAddresses();

    public abstract List<ProvisioningEvent> provisioningEvents();

    public abstract Plan plan();

    @Nullable
    public abstract String rootPassword();

    public abstract String userdata();

    public abstract String href();

    @SerializedNames(value={"id", "short_id", "hostname", "description", "state", "tags", "billing_cycle", "user", "iqn", "locked", "bonding_mode", "created_at", "updated_at", "operating_system", "facility", "project", "ssh_keys", "project_lite", "volumes", "ip_addresses", "provisioning_events", "plan", "root_password", "userdata", "href"})
    public static Device create(String id, String shortId, String hostname, String description, State state, List<String> tags, String billingCycle, String user, String iqn, Boolean locked, String bondingMode, Date createdAt, Date updatedAt, OperatingSystem operatingSystem, Facility facility, Href project, List<Href> sshKeys, Href projectLite, List<Object> volumes, List<IpAddress> ipAddresses, List<ProvisioningEvent> provisioningEvents, Plan plan, String rootPassword, String userdata, String href) {
        return new AutoValue_Device(id, shortId, hostname, description, state, (List<String>)(tags == null ? ImmutableList.of() : ImmutableList.copyOf(tags)), billingCycle, user, iqn, locked, bondingMode, createdAt, updatedAt, operatingSystem, facility, project, (List<Href>)(sshKeys == null ? ImmutableList.of() : ImmutableList.copyOf(sshKeys)), projectLite, (List<Object>)(volumes == null ? ImmutableList.of() : ImmutableList.copyOf(volumes)), (List<IpAddress>)(ipAddresses == null ? ImmutableList.of() : ImmutableList.copyOf(ipAddresses)), (List<ProvisioningEvent>)(provisioningEvents == null ? ImmutableList.of() : ImmutableList.copyOf(provisioningEvents)), plan, rootPassword, userdata, href);
    }

    Device() {
    }

    public static abstract class CreateDevice {
        public abstract String hostname();

        public abstract String plan();

        public abstract String billingCycle();

        public abstract String facility();

        public abstract Map<String, String> features();

        public abstract String operatingSystem();

        public abstract Boolean locked();

        public abstract String userdata();

        public abstract Set<String> tags();

        @SerializedNames(value={"hostname", "plan", "billing_cycle", "facility", "features", "operating_system", "locked", "userdata", "tags"})
        private static CreateDevice create(String hostname, String plan, String billingCycle, String facility, Map<String, String> features, String operatingSystem, Boolean locked, String userdata, Set<String> tags) {
            return CreateDevice.builder().hostname(hostname).plan(plan).billingCycle(billingCycle).facility(facility).features(features).operatingSystem(operatingSystem).locked(locked).userdata(userdata).tags(tags).build();
        }

        public static Builder builder() {
            return new AutoValue_Device_CreateDevice.Builder();
        }

        public static abstract class Builder {
            public abstract Builder hostname(String var1);

            public abstract Builder plan(String var1);

            public abstract Builder billingCycle(String var1);

            public abstract Builder facility(String var1);

            public abstract Builder features(Map<String, String> var1);

            public abstract Builder operatingSystem(String var1);

            public abstract Builder locked(Boolean var1);

            public abstract Builder userdata(String var1);

            public abstract Builder tags(Set<String> var1);

            abstract Map<String, String> features();

            abstract Set<String> tags();

            abstract CreateDevice autoBuild();

            public CreateDevice build() {
                return this.tags((Set<String>)(this.tags() != null ? ImmutableSet.copyOf(this.tags()) : ImmutableSet.of())).features((Map<String, String>)(this.features() != null ? ImmutableMap.copyOf(this.features()) : ImmutableMap.of())).autoBuild();
            }
        }
    }

    public static enum State {
        PROVISIONING,
        QUEUED,
        ACTIVE,
        REBOOTING,
        POWERING_OFF,
        POWERING_ON,
        INACTIVE;


        public static State fromValue(String value) {
            Optional state = Enums.getIfPresent(State.class, (String)value.toUpperCase());
            Preconditions.checkArgument((boolean)state.isPresent(), (String)"Expected one of %s but was %s", (Object[])new Object[]{Joiner.on((char)',').join((Object[])State.values()), value});
            return (State)((Object)state.get());
        }
    }
}

