/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.features;

import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.filters.SharedKeyLiteAuthentication;
import org.jclouds.gogrid.functions.ParseIpListFromJsonResponse;
import org.jclouds.gogrid.functions.ParseOptionsFromJsonResponse;
import org.jclouds.gogrid.options.GetIpListOptions;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={SharedKeyLiteAuthentication.class})
@QueryParams(keys={"v"}, values={"{jclouds.api-version}"})
public interface GridIpApi {
    @GET
    @ResponseParser(value=ParseIpListFromJsonResponse.class)
    @Path(value="/grid/ip/list")
    public Set<Ip> getIpList(GetIpListOptions ... var1);

    @GET
    @ResponseParser(value=ParseIpListFromJsonResponse.class)
    @Path(value="/grid/ip/list")
    @QueryParams(keys={"ip.state"}, values={"Unassigned"})
    public Set<Ip> getUnassignedIpList();

    @GET
    @ResponseParser(value=ParseIpListFromJsonResponse.class)
    @Path(value="/grid/ip/list")
    @QueryParams(keys={"ip.state", "ip.type"}, values={"Unassigned", "Public"})
    public Set<Ip> getUnassignedPublicIpList();

    @GET
    @ResponseParser(value=ParseIpListFromJsonResponse.class)
    @Path(value="/grid/ip/list")
    @QueryParams(keys={"ip.state"}, values={"Assigned"})
    public Set<Ip> getAssignedIpList();

    @GET
    @ResponseParser(value=ParseOptionsFromJsonResponse.class)
    @Path(value="/common/lookup/list")
    @QueryParams(keys={"lookup"}, values={"ip.datacenter"})
    public Set<Option> getDatacenters();
}

