/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class ResourceUsageInfo {
    private final String resource;
    private final String resolution;
    private final String unit;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromResourceUsageInfo(this);
    }

    @ConstructorProperties(value={"type", "resolution", "unit"})
    protected ResourceUsageInfo(String resource, String resolution, String unit) {
        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"resource");
        this.resolution = (String)Preconditions.checkNotNull((Object)resolution, (Object)"resolution");
        this.unit = (String)Preconditions.checkNotNull((Object)unit, (Object)"unit");
    }

    public String getResource() {
        return this.resource;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getUnit() {
        return this.unit;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.resource, this.resolution, this.unit});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceUsageInfo that = (ResourceUsageInfo)ResourceUsageInfo.class.cast(obj);
        return Objects.equal((Object)this.resource, (Object)that.resource) && Objects.equal((Object)this.resolution, (Object)that.resolution) && Objects.equal((Object)this.unit, (Object)that.unit);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("resource", (Object)this.resource).add("resolution", (Object)this.resolution).add("unit", (Object)this.unit);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String resource;
        protected String resolution;
        protected String unit;

        protected abstract T self();

        public T resource(String resource) {
            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"resource");
            return this.self();
        }

        public T resolution(String resolution) {
            this.resolution = (String)Preconditions.checkNotNull((Object)resolution, (Object)"resolution");
            return this.self();
        }

        public T unit(String unit) {
            this.unit = (String)Preconditions.checkNotNull((Object)unit, (Object)"unit");
            return this.self();
        }

        public ResourceUsageInfo build() {
            return new ResourceUsageInfo(this.resource, this.resolution, this.unit);
        }

        public T fromResourceUsageInfo(ResourceUsageInfo in) {
            return ((Builder)((Builder)this.resource(in.getResource())).resolution(in.getResolution())).unit(in.getUnit());
        }
    }
}

