/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class OSTemplate {
    private final String name;
    private final int minDiskSize;
    private final int minMemSize;
    private final String os;
    private final String platform;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromOSTemplate(this);
    }

    @ConstructorProperties(value={"name", "minimumdisksize", "minimummemorysize", "operatingsystem", "platform"})
    protected OSTemplate(String name, int minDiskSize, int minMemSize, String os, String platform) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.minDiskSize = minDiskSize;
        this.minMemSize = minMemSize;
        this.os = (String)Preconditions.checkNotNull((Object)os, (Object)"os");
        this.platform = (String)Preconditions.checkNotNull((Object)platform, (Object)"platform");
    }

    public String getName() {
        return this.name;
    }

    public int getMinDiskSize() {
        return this.minDiskSize;
    }

    public int getMinMemSize() {
        return this.minMemSize;
    }

    public String getOs() {
        return this.os;
    }

    public String getPlatform() {
        return this.platform;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.platform});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OSTemplate that = (OSTemplate)OSTemplate.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.platform, (Object)that.platform);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("name", (Object)this.name).add("minDiskSize", this.minDiskSize).add("minMemSize", this.minMemSize).add("os", (Object)this.os).add("platform", (Object)this.platform);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected int minDiskSize;
        protected int minMemSize;
        protected String os;
        protected String platform;

        protected abstract T self();

        public T name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this.self();
        }

        public T minDiskSize(int minDiskSize) {
            this.minDiskSize = minDiskSize;
            return this.self();
        }

        public T minMemSize(int minMemSize) {
            this.minMemSize = minMemSize;
            return this.self();
        }

        public T os(String os) {
            this.os = (String)Preconditions.checkNotNull((Object)os, (Object)"os");
            return this.self();
        }

        public T platform(String platform) {
            this.platform = (String)Preconditions.checkNotNull((Object)platform, (Object)"platform");
            return this.self();
        }

        public OSTemplate build() {
            return new OSTemplate(this.name, this.minDiskSize, this.minMemSize, this.os, this.platform);
        }

        public T fromOSTemplate(OSTemplate in) {
            return ((Builder)((Builder)((Builder)((Builder)this.name(in.getName())).minDiskSize(in.getMinDiskSize())).minMemSize(in.getMinMemSize())).os(in.getOs())).platform(in.getPlatform());
        }
    }
}

