/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import org.jclouds.glesys.domain.Cost;
import org.jclouds.glesys.domain.GleSYSBoolean;
import org.jclouds.javax.annotation.Nullable;

public class IpDetails {
    private final String datacenter;
    private final int version;
    private final String ptr;
    private final String platform;
    private final String address;
    private final String netmask;
    private final String broadcast;
    private final String gateway;
    private final List<String> nameServers;
    private final String serverId;
    private final Cost cost;
    private final boolean reserved;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromIpDetails(this);
    }

    @ConstructorProperties(value={"datacenter", "ipversion", "ptr", "platform", "ipaddress", "netmask", "broadcast", "gateway", "nameservers", "serverid", "cost", "reserved"})
    protected IpDetails(String datacenter, int version, String ptr, String platform, String address, @Nullable String netmask, @Nullable String broadcast, @Nullable String gateway, List<String> nameServers, @Nullable String serverId, Cost cost, GleSYSBoolean reserved) {
        this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
        this.version = version;
        this.ptr = (String)Preconditions.checkNotNull((Object)ptr, (Object)"ptr");
        this.platform = (String)Preconditions.checkNotNull((Object)platform, (Object)"platform");
        this.address = address;
        this.netmask = netmask;
        this.broadcast = broadcast;
        this.gateway = gateway;
        this.nameServers = ImmutableList.copyOf(nameServers);
        this.serverId = serverId;
        this.cost = (Cost)Preconditions.checkNotNull((Object)cost, (Object)"cost");
        this.reserved = ((GleSYSBoolean)Preconditions.checkNotNull((Object)reserved, (Object)"reserved")).getValue();
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public int getVersion() {
        return this.version;
    }

    public String getPtr() {
        return this.ptr;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getAddress() {
        return this.address;
    }

    @Nullable
    public String getNetmask() {
        return this.netmask;
    }

    @Nullable
    public String getBroadcast() {
        return this.broadcast;
    }

    @Nullable
    public String getGateway() {
        return this.gateway;
    }

    public List<String> getNameServers() {
        return this.nameServers;
    }

    @Nullable
    public String getServerId() {
        return this.serverId;
    }

    public Cost getCost() {
        return this.cost;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datacenter, this.version, this.ptr, this.platform, this.address, this.netmask, this.broadcast, this.gateway, this.nameServers, this.serverId, this.cost, this.reserved});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IpDetails that = (IpDetails)IpDetails.class.cast(obj);
        return Objects.equal((Object)this.datacenter, (Object)that.datacenter) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.ptr, (Object)that.ptr) && Objects.equal((Object)this.platform, (Object)that.platform) && Objects.equal((Object)this.address, (Object)that.address) && Objects.equal((Object)this.netmask, (Object)that.netmask) && Objects.equal((Object)this.broadcast, (Object)that.broadcast) && Objects.equal((Object)this.gateway, (Object)that.gateway) && Objects.equal(this.nameServers, that.nameServers) && Objects.equal((Object)this.serverId, (Object)that.serverId) && Objects.equal((Object)this.cost, (Object)that.cost) && Objects.equal((Object)this.reserved, (Object)that.reserved);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("datacenter", (Object)this.datacenter).add("ipversion", this.version).add("ptr", (Object)this.ptr).add("platform", (Object)this.platform).add("address", (Object)this.address).add("netmask", (Object)this.netmask).add("broadcast", (Object)this.broadcast).add("gateway", (Object)this.gateway).add("nameServers", this.nameServers).add("serverId", (Object)this.serverId).add("cost", (Object)this.cost).add("reserved", this.reserved);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String datacenter;
        protected int ipversion;
        protected String ptr;
        protected String platform;
        protected String address;
        protected String netmask;
        protected String broadcast;
        protected String gateway;
        protected List<String> nameServers = ImmutableList.of();
        protected String serverId;
        protected Cost cost;
        protected boolean reserved;

        protected abstract T self();

        public T datacenter(String datacenter) {
            this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
            return this.self();
        }

        protected T version(int ipversion) {
            this.ipversion = ipversion;
            return this.self();
        }

        public T version4() {
            return this.version(4);
        }

        public T version6() {
            return this.version(6);
        }

        public T ptr(String ptr) {
            this.ptr = (String)Preconditions.checkNotNull((Object)ptr, (Object)"ptr");
            return this.self();
        }

        public T platform(String platform) {
            this.platform = (String)Preconditions.checkNotNull((Object)platform, (Object)"platform");
            return this.self();
        }

        public T address(String address) {
            this.address = address;
            return this.self();
        }

        public T netmask(String netmask) {
            this.netmask = netmask;
            return this.self();
        }

        public T broadcast(String broadcast) {
            this.broadcast = broadcast;
            return this.self();
        }

        public T gateway(String gateway) {
            this.gateway = gateway;
            return this.self();
        }

        public T nameServers(List<String> nameservers) {
            this.nameServers = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(nameservers, (Object)"nameServers")));
            return this.self();
        }

        public T nameServers(String ... in) {
            return this.nameServers((List<String>)ImmutableList.copyOf((Object[])in));
        }

        public T serverId(String serverId) {
            this.serverId = serverId;
            return this.self();
        }

        public T cost(Cost cost) {
            this.cost = cost;
            return this.self();
        }

        public T reserved(boolean reserved) {
            this.reserved = reserved;
            return this.self();
        }

        public IpDetails build() {
            return new IpDetails(this.datacenter, this.ipversion, this.ptr, this.platform, this.address, this.netmask, this.broadcast, this.gateway, this.nameServers, this.serverId, this.cost, new GleSYSBoolean(this.reserved));
        }

        public T fromIpDetails(IpDetails in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.datacenter(in.getDatacenter())).version(in.getVersion())).ptr(in.getPtr())).platform(in.getPlatform())).address(in.getAddress())).netmask(in.getNetmask())).broadcast(in.getBroadcast())).gateway(in.getGateway())).nameServers(in.getNameServers())).serverId(in.getServerId())).cost(in.getCost())).reserved(in.isReserved());
        }
    }
}

