/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.glesys.domain.GleSYSBoolean;
import org.jclouds.javax.annotation.Nullable;

public class Domain {
    private final String domainName;
    private final Date createTime;
    private final int recordCount;
    private final boolean useGlesysNameServer;
    private final String primaryNameServer;
    private final String responsiblePerson;
    private final int ttl;
    private final int refresh;
    private final int retry;
    private final int expire;
    private final int minimum;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromDomain(this);
    }

    @ConstructorProperties(value={"domainname", "createtime", "recordcount", "usingglesysnameserver", "primarynameserver", "responsibleperson", "ttl", "refresh", "retry", "expire", "minimum"})
    protected Domain(String domainName, @Nullable Date createTime, int recordCount, GleSYSBoolean useGlesysNameServer, @Nullable String primaryNameServer, @Nullable String responsiblePerson, int ttl, int refresh, int retry, int expire, int minimum) {
        this.domainName = (String)Preconditions.checkNotNull((Object)domainName, (Object)"domainName");
        this.createTime = createTime;
        this.recordCount = recordCount;
        this.useGlesysNameServer = ((GleSYSBoolean)Preconditions.checkNotNull((Object)useGlesysNameServer, (Object)"useGlesysNameServer")).getValue();
        this.primaryNameServer = primaryNameServer;
        this.responsiblePerson = responsiblePerson;
        this.ttl = ttl;
        this.refresh = refresh;
        this.retry = retry;
        this.expire = expire;
        this.minimum = minimum;
    }

    public String getName() {
        return this.domainName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public boolean isUseGlesysNameServer() {
        return this.useGlesysNameServer;
    }

    @Nullable
    public String getPrimaryNameServer() {
        return this.primaryNameServer;
    }

    @Nullable
    public String getResponsiblePerson() {
        return this.responsiblePerson;
    }

    public int getTtl() {
        return this.ttl;
    }

    public int getRefresh() {
        return this.refresh;
    }

    public int getRetry() {
        return this.retry;
    }

    public int getExpire() {
        return this.expire;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domainName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Domain that = (Domain)Domain.class.cast(obj);
        return Objects.equal((Object)this.domainName, (Object)that.domainName);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("domainName", (Object)this.domainName).add("createTime", (Object)this.createTime).add("recordCount", this.recordCount).add("useGlesysNameServer", this.useGlesysNameServer);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String domainName;
        protected Date createTime;
        protected int recordCount;
        protected boolean useGlesysNameServer;
        protected String primaryNameServer;
        protected String responsiblePerson;
        protected int ttl;
        protected int refresh;
        protected int retry;
        protected int expire;
        protected int minimum;

        protected abstract T self();

        public T domainName(String domainName) {
            this.domainName = (String)Preconditions.checkNotNull((Object)domainName, (Object)"domainName");
            return this.self();
        }

        public T createTime(Date createTime) {
            this.createTime = createTime;
            return this.self();
        }

        public T recordCount(int recordCount) {
            this.recordCount = recordCount;
            return this.self();
        }

        public T useGlesysNameServer(boolean useGlesysNameServer) {
            this.useGlesysNameServer = useGlesysNameServer;
            return this.self();
        }

        public T primaryNameServer(String primaryNameServer) {
            this.primaryNameServer = primaryNameServer;
            return this.self();
        }

        public T responsiblePerson(String responsiblePerson) {
            this.responsiblePerson = responsiblePerson;
            return this.self();
        }

        public T ttl(int ttl) {
            this.ttl = ttl;
            return this.self();
        }

        public T refresh(int refresh) {
            this.refresh = refresh;
            return this.self();
        }

        public T retry(int retry) {
            this.retry = retry;
            return this.self();
        }

        public T expire(int expire) {
            this.expire = expire;
            return this.self();
        }

        public T minimum(int minimum) {
            this.minimum = minimum;
            return this.self();
        }

        public Domain build() {
            return new Domain(this.domainName, this.createTime, this.recordCount, new GleSYSBoolean(this.useGlesysNameServer), this.primaryNameServer, this.responsiblePerson, this.ttl, this.refresh, this.retry, this.expire, this.minimum);
        }

        public T fromDomain(Domain in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.domainName(in.getName())).createTime(in.getCreateTime())).recordCount(in.getRecordCount())).useGlesysNameServer(in.isUseGlesysNameServer())).primaryNameServer(in.getPrimaryNameServer())).responsiblePerson(in.getResponsiblePerson())).ttl(in.getTtl())).refresh(in.getRefresh())).retry(in.getRetry())).expire(in.getExpire());
        }
    }
}

