/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.glesys.domain.AllowedArguments;

public class AllowedArgumentsForCreateServer {
    private final AllowedArguments diskSizesInGB;
    private final AllowedArguments memorySizesInMB;
    private final AllowedArguments cpuCoreOptions;
    private final Set<String> templateNames;
    private final AllowedArguments transfersInGB;
    private final Set<String> dataCenters;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromAllowedArgumentsForCreateServer(this);
    }

    @ConstructorProperties(value={"disksize", "memorysize", "cpucores", "template", "transfer", "datacenter"})
    protected AllowedArgumentsForCreateServer(AllowedArguments diskSizesInGB, AllowedArguments memorySizesInMB, AllowedArguments cpuCoreOptions, Set<String> templateNames, AllowedArguments transfersInGB, Set<String> dataCenters) {
        this.diskSizesInGB = (AllowedArguments)Preconditions.checkNotNull((Object)diskSizesInGB, (Object)"diskSizesInGB");
        this.memorySizesInMB = (AllowedArguments)Preconditions.checkNotNull((Object)memorySizesInMB, (Object)"memorySizesInMB");
        this.cpuCoreOptions = (AllowedArguments)Preconditions.checkNotNull((Object)cpuCoreOptions, (Object)"cpuCoreOptions");
        this.templateNames = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(templateNames, (Object)"templateNames")));
        this.transfersInGB = (AllowedArguments)Preconditions.checkNotNull((Object)transfersInGB, (Object)"transfersInGB");
        this.dataCenters = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(dataCenters, (Object)"dataCenters")));
    }

    public AllowedArguments getDiskSizesInGB() {
        return this.diskSizesInGB;
    }

    public AllowedArguments getMemorySizesInMB() {
        return this.memorySizesInMB;
    }

    public AllowedArguments getCpuCoreOptions() {
        return this.cpuCoreOptions;
    }

    public Set<String> getTemplateNames() {
        return this.templateNames;
    }

    public AllowedArguments getTransfersInGB() {
        return this.transfersInGB;
    }

    public Set<String> getDataCenters() {
        return this.dataCenters;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.diskSizesInGB, this.memorySizesInMB, this.cpuCoreOptions, this.templateNames, this.transfersInGB, this.dataCenters});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AllowedArgumentsForCreateServer that = (AllowedArgumentsForCreateServer)AllowedArgumentsForCreateServer.class.cast(obj);
        return Objects.equal((Object)this.diskSizesInGB, (Object)that.diskSizesInGB) && Objects.equal((Object)this.memorySizesInMB, (Object)that.memorySizesInMB) && Objects.equal((Object)this.cpuCoreOptions, (Object)that.cpuCoreOptions) && Objects.equal(this.templateNames, that.templateNames) && Objects.equal((Object)this.transfersInGB, (Object)that.transfersInGB) && Objects.equal(this.dataCenters, that.dataCenters);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("diskSizesInGB", (Object)this.diskSizesInGB).add("memorySizesInMB", (Object)this.memorySizesInMB).add("cpuCoreOptions", (Object)this.cpuCoreOptions).add("templateNames", this.templateNames).add("transfersInGB", (Object)this.transfersInGB).add("dataCenters", this.dataCenters);
    }

    public String toString() {
        return this.string().toString();
    }

    public static class Builder {
        protected AllowedArguments diskSizes;
        protected AllowedArguments memorySizes;
        protected AllowedArguments cpuCores;
        protected Set<String> templates = ImmutableSet.of();
        protected AllowedArguments transfers;
        protected Set<String> dataCenters = ImmutableSet.of();

        public Builder diskSizes(AllowedArguments diskSizes) {
            this.diskSizes = (AllowedArguments)Preconditions.checkNotNull((Object)diskSizes, (Object)"diskSizesInGB");
            return this;
        }

        public Builder memorySizes(AllowedArguments memorySizes) {
            this.memorySizes = (AllowedArguments)Preconditions.checkNotNull((Object)memorySizes, (Object)"memorySizesInMB");
            return this;
        }

        public Builder cpuCores(AllowedArguments cpuCores) {
            this.cpuCores = (AllowedArguments)Preconditions.checkNotNull((Object)cpuCores, (Object)"cpuCoreOptions");
            return this;
        }

        public Builder templates(Set<String> templates) {
            this.templates = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(templates, (Object)"templateNames")));
            return this;
        }

        public Builder templates(String ... in) {
            return this.templates((Set<String>)ImmutableSet.copyOf((Object[])in));
        }

        public Builder transfers(AllowedArguments transfers) {
            this.transfers = (AllowedArguments)Preconditions.checkNotNull((Object)transfers, (Object)"transfersInGB");
            return this;
        }

        public Builder dataCenters(Set<String> dataCenters) {
            this.dataCenters = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(dataCenters, (Object)"dataCenters")));
            return this;
        }

        public Builder dataCenters(String ... in) {
            return this.dataCenters((Set<String>)ImmutableSet.copyOf((Object[])in));
        }

        public AllowedArgumentsForCreateServer build() {
            return new AllowedArgumentsForCreateServer(this.diskSizes, this.memorySizes, this.cpuCores, this.templates, this.transfers, this.dataCenters);
        }

        public Builder fromAllowedArgumentsForCreateServer(AllowedArgumentsForCreateServer in) {
            return this.diskSizes(in.getDiskSizesInGB()).memorySizes(in.getMemorySizesInMB()).cpuCores(in.getCpuCoreOptions()).templates(in.getTemplateNames()).transfers(in.getTransfersInGB()).dataCenters(in.getDataCenters());
        }
    }
}

