/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.glesys.domain.EmailAccount;
import org.jclouds.glesys.domain.EmailAlias;
import org.jclouds.glesys.domain.EmailOverview;
import org.jclouds.glesys.options.CreateAccountOptions;
import org.jclouds.glesys.options.UpdateAccountOptions;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={BasicAuthentication.class})
public interface EmailAccountApi {
    @Named(value="email:overview")
    @POST
    @Path(value="/email/overview/format/json")
    @SelectJson(value={"overview"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public EmailOverview getOverview();

    @Named(value="email:list:accounts")
    @POST
    @Path(value="/email/list/format/json")
    @SelectJson(value={"emailaccounts"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<EmailAccount> listDomain(@FormParam(value="domainname") String var1);

    @Named(value="email:list:aliases")
    @POST
    @Path(value="/email/list/format/json")
    @SelectJson(value={"emailaliases"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<EmailAlias> listAliasesInDomain(@FormParam(value="domainname") String var1);

    @Named(value="email:createaccount")
    @POST
    @Consumes(value={"application/json"})
    @SelectJson(value={"emailaccount"})
    @Path(value="/email/createaccount/format/json")
    public EmailAccount createWithPassword(@FormParam(value="emailaccount") String var1, @FormParam(value="password") String var2, CreateAccountOptions ... var3);

    @Named(value="email:createalias")
    @POST
    @Consumes(value={"application/json"})
    @SelectJson(value={"alias"})
    @Path(value="/email/createalias/format/json")
    public EmailAlias createAlias(@FormParam(value="emailalias") String var1, @FormParam(value="goto") String var2);

    @Named(value="email:editaccount")
    @POST
    @Consumes(value={"application/json"})
    @SelectJson(value={"emailaccount"})
    @Path(value="/email/editaccount/format/json")
    public EmailAccount update(@FormParam(value="emailaccount") String var1, UpdateAccountOptions ... var2);

    @Named(value="email:editalias")
    @POST
    @Consumes(value={"application/json"})
    @SelectJson(value={"alias"})
    @Path(value="/email/editalias/format/json")
    public EmailAlias updateAlias(@FormParam(value="emailalias") String var1, @FormParam(value="goto") String var2);

    @Named(value="email:delete")
    @POST
    @Path(value="/email/delete/format/json")
    @Fallback(value=Fallbacks.TrueOnNotFoundOr404.class)
    public boolean delete(@FormParam(value="email") String var1);
}

