/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class EmailAlias {
    private final String alias;
    private final String forwardTo;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromEmailAlias(this);
    }

    @ConstructorProperties(value={"emailalias", "goto"})
    protected EmailAlias(String alias, String forwardTo) {
        this.alias = (String)Preconditions.checkNotNull((Object)alias, (Object)"alias");
        this.forwardTo = (String)Preconditions.checkNotNull((Object)forwardTo, (Object)"forwardTo");
    }

    public String getAlias() {
        return this.alias;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alias});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EmailAlias that = (EmailAlias)EmailAlias.class.cast(obj);
        return Objects.equal((Object)this.alias, (Object)that.alias);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("alias", (Object)this.alias).add("forwardTo", (Object)this.forwardTo);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String alias;
        protected String forwardTo;

        protected abstract T self();

        public T alias(String alias) {
            this.alias = (String)Preconditions.checkNotNull((Object)alias, (Object)"alias");
            return this.self();
        }

        public T forwardTo(String forwardTo) {
            this.forwardTo = (String)Preconditions.checkNotNull((Object)forwardTo, (Object)"forwardTo");
            return this.self();
        }

        public EmailAlias build() {
            return new EmailAlias(this.alias, this.forwardTo);
        }

        public T fromEmailAlias(EmailAlias in) {
            return ((Builder)this.alias(in.getAlias())).forwardTo(in.getForwardTo());
        }
    }
}

