/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.base.Predicate;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.domain.Domain;
import org.jclouds.glesys.domain.DomainRecord;
import org.jclouds.glesys.features.DomainApi;
import org.jclouds.glesys.internal.BaseGleSYSApiLiveTest;
import org.jclouds.glesys.options.AddRecordOptions;
import org.jclouds.glesys.options.DomainOptions;
import org.jclouds.glesys.options.UpdateRecordOptions;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="DomainApiLiveTest", singleThreaded=true)
public class DomainApiLiveTest
extends BaseGleSYSApiLiveTest {
    public String testDomain;
    private DomainApi domainApi;
    private Predicate<Integer> domainCounter;
    private Predicate<Integer> recordCounter;

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.testDomain = this.identity.toLowerCase() + "-domain.jclouds.org";
        this.domainApi = ((GleSYSApi)this.api).getDomainApi();
        this.domainCounter = Predicates2.retry((Predicate)new Predicate<Integer>(){

            public boolean apply(Integer value) {
                return DomainApiLiveTest.this.domainApi.list().size() == value.intValue();
            }
        }, (long)30L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.recordCounter = Predicates2.retry((Predicate)new Predicate<Integer>(){

            public boolean apply(Integer value) {
                return DomainApiLiveTest.this.domainApi.listRecords(DomainApiLiveTest.this.testDomain).size() == value.intValue();
            }
        }, (long)30L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        try {
            this.domainApi.delete(this.testDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createDomain(this.testDomain);
    }

    @AfterClass(groups={"integration", "live"})
    public void tearDown() {
        int before = this.domainApi.list().size();
        this.domainApi.delete(this.testDomain);
        Assert.assertTrue((boolean)this.domainCounter.apply((Object)(before - 1)));
        super.tearDown();
    }

    @Test
    public void testGetDomain() throws Exception {
        Domain domain = this.domainApi.get(this.testDomain);
        Assert.assertNotNull((Object)domain);
        Assert.assertEquals((String)domain.getName(), (String)this.testDomain);
        Assert.assertNotNull((Object)domain.getCreateTime());
    }

    @Test
    public void testUpdateDomain() throws Exception {
        this.domainApi.update(this.testDomain, DomainOptions.Builder.responsiblePerson((String)"another-tester.jclouds.org."));
        Domain domain = this.domainApi.get(this.testDomain);
        Assert.assertEquals((String)domain.getResponsiblePerson(), (String)"another-tester.jclouds.org.");
    }

    @Test
    public void testCreateRecord() throws Exception {
        int before = this.domainApi.listRecords(this.testDomain).size();
        this.domainApi.createRecord(this.testDomain, "test", "A", "127.0.0.1", new AddRecordOptions[0]);
        Assert.assertTrue((boolean)this.recordCounter.apply((Object)(before + 1)));
        for (DomainRecord record : this.domainApi.listRecords(this.testDomain)) {
            if (!"test".equals(record.getHost())) continue;
            Assert.assertEquals((String)record.getType(), (String)"A");
            Assert.assertEquals((String)record.getData(), (String)"127.0.0.1");
        }
    }

    @Test
    public void testUpdateRecord() throws Exception {
        int before = this.domainApi.listRecords(this.testDomain).size();
        this.domainApi.createRecord(this.testDomain, "testeditbefore", "A", "127.0.0.1", new AddRecordOptions[0]);
        Assert.assertTrue((boolean)this.recordCounter.apply((Object)(before + 1)));
        String recordId = null;
        for (DomainRecord record : this.domainApi.listRecords(this.testDomain)) {
            if (!"testeditbefore".equals(record.getHost())) continue;
            Assert.assertEquals((String)record.getType(), (String)"A");
            Assert.assertEquals((String)record.getData(), (String)"127.0.0.1");
            recordId = record.getId();
        }
        Assert.assertNotNull(recordId);
        this.domainApi.updateRecord(recordId, UpdateRecordOptions.Builder.host((String)"testeditafter"));
        boolean found = false;
        for (DomainRecord record : this.domainApi.listRecords(this.testDomain)) {
            if (!recordId.equals(record.getId())) continue;
            Assert.assertEquals((String)record.getHost(), (String)"testeditafter");
            Assert.assertEquals((String)record.getType(), (String)"A");
            Assert.assertEquals((String)record.getData(), (String)"127.0.0.1");
            found = true;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testDeleteRecord() throws Exception {
        Set domainRecords = this.domainApi.listRecords(this.testDomain);
        int before = domainRecords.size();
        this.domainApi.deleteRecord(((DomainRecord)domainRecords.iterator().next()).getId());
        Assert.assertTrue((boolean)this.recordCounter.apply((Object)(before - 1)));
    }
}

