/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.util.ComputeServiceUtils;

@Singleton
public class ParseOsFamilyVersion64BitFromImageName
implements Function<String, OsFamilyVersion64Bit> {
    private final Map<OsFamily, Map<String, String>> osVersionMap;
    public static final Pattern OSFAMILY_VERSION = Pattern.compile("([^ ]+).*[ -]([0-9.]+)( LTS)?( [36][24]-bit)?( x[68][46])?$");
    public static final Pattern OSFAMILY = Pattern.compile("([^ ]+).*$");

    @Inject
    public ParseOsFamilyVersion64BitFromImageName(Map<OsFamily, Map<String, String>> osVersionMap) {
        this.osVersionMap = osVersionMap;
    }

    public OsFamilyVersion64Bit apply(String input) {
        boolean is64Bit = Predicates.containsPattern((String)"64").apply((Object)input);
        String version = "";
        if (input.indexOf("Windows") != -1) {
            Matcher matcher = Pattern.compile(".*(20[01][0-9] R[1-9]).*").matcher(input);
            if (matcher.find()) {
                version = matcher.group(1);
            } else {
                matcher = Pattern.compile(".*(20[01][0-9]).*").matcher(input);
                if (matcher.find()) {
                    version = matcher.group(1);
                }
            }
            return new OsFamilyVersion64Bit(OsFamily.WINDOWS, this.osVersionMap.get(OsFamily.WINDOWS).get(version), is64Bit);
        }
        Matcher osFamilyVersionMatcher = OSFAMILY_VERSION.matcher(input);
        if (osFamilyVersionMatcher.find()) {
            OsFamily fam = OsFamily.fromValue((String)osFamilyVersionMatcher.group(1).toLowerCase());
            if (fam == OsFamily.UNRECOGNIZED) {
                return new OsFamilyVersion64Bit(OsFamily.UNRECOGNIZED, version, is64Bit);
            }
            return new OsFamilyVersion64Bit(fam, ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)fam, (String)osFamilyVersionMatcher.group(2), this.osVersionMap), is64Bit);
        }
        Matcher osFamilyMatcher = OSFAMILY.matcher(input);
        OsFamily fam = OsFamily.UNRECOGNIZED;
        if (osFamilyMatcher.find()) {
            fam = OsFamily.fromValue((String)osFamilyMatcher.group(1).toLowerCase());
        }
        return new OsFamilyVersion64Bit(fam, version, is64Bit);
    }
}

