/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.glesys.handlers.GleSYSErrorHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class GleSYSErrorHandlerTest {
    @Test
    public void test401MakesAuthorizationException() {
        this.assertCodeMakes("GET", URI.create("https://api.glesys.com/foo"), 401, "", "Unauthorized", AuthorizationException.class);
    }

    @Test
    public void test500LockedMakesIllegalStateException() {
        this.assertCodeMakes("POST", URI.create("https://api.glesys.com/server/destroy/format/json"), 500, "", "{\"response\":{\"status\":{\"code\":606,\"timestamp\":\"2012-02-14T15:48:39+01:00\",\"text\":\"Server Locked\"},\"debug\":{\"input\":{\"serverid\":\"xm3270596\",\"keepip\":\"0\"}}}}", IllegalStateException.class);
    }

    @Test
    public void test400MakesResourceNotFoundExceptionOnCouldNotFind() {
        this.assertCodeMakes("POST", URI.create("https://api.glesys.com/domain/delete/format/json"), 400, "", "{\"response\":{\"status\":{\"code\":400,\"timestamp\":\"2012-02-10T12:07:56+01:00\",\"text\":\"Could not find server with this id on this account.\n\"},\"debug\":{\"input\":{\"domainname\":\"email-test.jclouds.org\"}}}}", ResourceNotFoundException.class);
    }

    @Test
    public void test404MakesResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://api.glesys.com/foo"), 404, "", "Not Found", ResourceNotFoundException.class);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String content, Class<? extends Exception> expected) {
        this.assertCodeMakes(method, uri, statusCode, message, "text/xml", content, expected);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected) {
        GleSYSErrorHandler function = (GleSYSErrorHandler)Guice.createInjector((Module[])new Module[0]).getInstance(GleSYSErrorHandler.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method(method).endpoint(uri).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(statusCode).message(message).payload(content)).build();
        response.getPayload().getContentMetadata().setContentType(contentType);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(GleSYSErrorHandlerTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }
}

