/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.domain.EmailAccount;
import org.jclouds.glesys.domain.EmailAlias;
import org.jclouds.glesys.domain.EmailOverview;
import org.jclouds.glesys.domain.EmailOverviewDomain;
import org.jclouds.glesys.domain.EmailOverviewSummary;
import org.jclouds.glesys.domain.EmailQuota;
import org.jclouds.glesys.features.EmailAccountApi;
import org.jclouds.glesys.internal.BaseGleSYSApiExpectTest;
import org.jclouds.glesys.options.CreateAccountOptions;
import org.jclouds.glesys.options.UpdateAccountOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EmailAccountAsyncApiTest")
public class EmailAccountApiExpectTest
extends BaseGleSYSApiExpectTest {
    public void testListWhenResponseIs2xx() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/list/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"cl13016.test.jclouds.org"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/email_list.json"))).build())).getEmailAccountApi();
        EmailAccount.Builder builder = EmailAccount.builder().quota(EmailQuota.builder().max(200).unit("MB").build()).antispamLevel(3).antiVirus(true).autoRespond(false).autoRespondSaveEmail(true);
        ImmutableSet expected = ImmutableSet.of((Object)builder.account("test1@cl13016.test.jclouds.org").antispamLevel(3).created(this.dateService.iso8601SecondsDateParse("2012-06-24T11:53:45+02:00")).build(), (Object)builder.account("test@cl13016.test.jclouds.org").antispamLevel(3).created(this.dateService.iso8601SecondsDateParse("2012-06-21T11:26:09+02:00")).modified(this.dateService.iso8601SecondsDateParse("2012-06-24T11:53:48+02:00")).build());
        ImmutableSet actual = api.listDomain("cl13016.test.jclouds.org").toSet();
        Assert.assertEquals((Set)actual, (Set)expected);
        Assert.assertEquals((String)((EmailAccount)Iterables.get((Iterable)actual, (int)0)).toString(), (String)((EmailAccount)Iterables.get((Iterable)expected, (int)0)).toString());
    }

    public void testListWhenResponseIs404IsEmpty() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/list/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"test"}).build(), HttpResponse.builder().statusCode(404).build())).getEmailAccountApi();
        Assert.assertTrue((boolean)api.listDomain("test").isEmpty());
    }

    public void testListAliasesWhenResponseIs2xx() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/list/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"cl13016.test.jclouds.org"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/email_list.json"))).build())).getEmailAccountApi();
        EmailAlias expected = EmailAlias.builder().alias("test2@cl13016.test.jclouds.org").forwardTo("test2@cl13016.test.jclouds.org").build();
        EmailAlias actual = (EmailAlias)Iterables.getOnlyElement((Iterable)api.listAliasesInDomain("cl13016.test.jclouds.org"));
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    public void testListAliasesWhenResponseIs404IsEmpty() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/list/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"test"}).build(), HttpResponse.builder().statusCode(404).build())).getEmailAccountApi();
        Assert.assertTrue((boolean)api.listAliasesInDomain("test").isEmpty());
    }

    public void testOverviewWhenResponseIs2xx() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/overview/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/email_overview.json"))).build())).getEmailAccountApi();
        EmailOverviewSummary summary = EmailOverviewSummary.builder().accounts(2).maxAccounts(50).aliases(1).maxAliases(1000).build();
        EmailOverviewDomain domain = EmailOverviewDomain.builder().domain("cl13016.test.jclouds.org").accounts(2).aliases(0).build();
        EmailOverview expected = EmailOverview.builder().summary(summary).domains(new EmailOverviewDomain[]{domain}).build();
        Assert.assertEquals((Object)api.getOverview(), (Object)expected);
    }

    public void testOverviewWhenResponseIs404ReturnsNull() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/overview/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), HttpResponse.builder().statusCode(404).build())).getEmailAccountApi();
        Assert.assertNull((Object)api.getOverview());
    }

    public void testCreateAccountWhenResponseIs2xx() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/createaccount/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("emailaccount", new String[]{"test@jclouds.org"}).addFormParam("password", new String[]{"newpass"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/email_details.json", "application/json"))).build())).getEmailAccountApi();
        Assert.assertEquals((String)api.createWithPassword("test@jclouds.org", "newpass", new CreateAccountOptions[0]).toString(), (String)this.getEmailAccountInDetails().toString());
    }

    public void testUpdateAccountWhenResponseIs2xx() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/editaccount/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("emailaccount", new String[]{"test@jclouds.org"}).addFormParam("password", new String[]{"anotherpass"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/email_details.json", "application/json"))).build())).getEmailAccountApi();
        Assert.assertEquals((String)api.update("test@jclouds.org", new UpdateAccountOptions[]{UpdateAccountOptions.Builder.password((String)"anotherpass")}).toString(), (String)this.getEmailAccountInDetails().toString());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testUpdateAccountWhenResponseIs4xx() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/editaccount/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("emailaccount", new String[]{"test@jclouds.org"}).addFormParam("password", new String[]{"anotherpass"}).build(), HttpResponse.builder().statusCode(404).build())).getEmailAccountApi();
        Assert.assertEquals((String)api.update("test@jclouds.org", new UpdateAccountOptions[]{UpdateAccountOptions.Builder.password((String)"anotherpass")}).toString(), (String)this.getEmailAccountInDetails().toString());
    }

    private EmailAccount getEmailAccountInDetails() {
        return EmailAccount.builder().account("test@CL13016.jclouds.org").antispamLevel(3).antiVirus(true).autoRespondSaveEmail(true).created(this.dateService.iso8601SecondsDateParse("2012-06-20T12:01:01+02:00")).quota(EmailQuota.builder().max(200).unit("MB").build()).build();
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testCreateAccountWhenResponseIs4xxThrows() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/createaccount/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("emailaccount", new String[]{"test@jclouds.org"}).addFormParam("password", new String[]{"newpass"}).build(), HttpResponse.builder().statusCode(404).build())).getEmailAccountApi();
        api.createWithPassword("test@jclouds.org", "newpass", new CreateAccountOptions[0]);
    }

    public void testCreateAliasWhenResponseIs2xx() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/createalias/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("emailalias", new String[]{"test2@jclouds.org"}).addFormParam("goto", new String[]{"test@jclouds.org"}).build(), HttpResponse.builder().statusCode(200).build())).getEmailAccountApi();
        api.createAlias("test2@jclouds.org", "test@jclouds.org");
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testCreateAliasWhenResponseIs4xxThrows() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/createalias/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("emailalias", new String[]{"test2@jclouds.org"}).addFormParam("goto", new String[]{"test@jclouds.org"}).build(), HttpResponse.builder().statusCode(401).build())).getEmailAccountApi();
        api.createAlias("test2@jclouds.org", "test@jclouds.org");
    }

    public void testUpdateAliasWhenResponseIs2xx() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/editalias/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("emailalias", new String[]{"test2@jclouds.org"}).addFormParam("goto", new String[]{"test@jclouds.org"}).build(), HttpResponse.builder().statusCode(200).build())).getEmailAccountApi();
        api.updateAlias("test2@jclouds.org", "test@jclouds.org");
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testUpdateAliasWhenResponseIs4xxThrows() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/editalias/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("emailalias", new String[]{"test2@jclouds.org"}).addFormParam("goto", new String[]{"test@jclouds.org"}).build(), HttpResponse.builder().statusCode(404).build())).getEmailAccountApi();
        api.updateAlias("test2@jclouds.org", "test@jclouds.org");
    }

    public void testDeleteWhenResponseIs2xx() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/delete/format/json").addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("email", new String[]{"test2@jclouds.org"}).build(), HttpResponse.builder().statusCode(200).build())).getEmailAccountApi();
        api.delete("test2@jclouds.org");
    }

    public void testDeleteWhenResponseIs4xxOk() throws Exception {
        EmailAccountApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/email/delete/format/json").addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("email", new String[]{"test2@jclouds.org"}).build(), HttpResponse.builder().statusCode(404).build())).getEmailAccountApi();
        api.delete("test2@jclouds.org");
    }
}

