/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.compute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.internal.BaseTemplateBuilderLiveTest;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.glesys.compute.options.GleSYSTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="GleSYSTemplateBuilderLiveTest")
public class GleSYSTemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    public GleSYSTemplateBuilderLiveTest() {
        this.provider = "glesys";
    }

    protected Predicate<OsFamilyVersion64Bit> defineUnsupportedOperatingSystems() {
        return Predicates.not((Predicate)new Predicate<OsFamilyVersion64Bit>(){

            public boolean apply(OsFamilyVersion64Bit input) {
                switch (input.family) {
                    case UBUNTU: {
                        return input.version.equals("") || input.version.equals("10.04") || input.version.equals("12.04") || (input.version.equals("8.04") || input.version.equals("11.04") || input.version.equals("10.10")) && input.is64Bit;
                    }
                    case DEBIAN: {
                        return input.version.equals("") || input.version.matches("[56].0");
                    }
                    case FEDORA: {
                        return input.version.equals("") || input.version.equals("13") || input.version.equals("15");
                    }
                    case CENTOS: {
                        return input.version.equals("") || input.version.equals("5") || input.version.equals("5.5") || input.version.equals("5.0") || input.version.equals("6.0");
                    }
                    case WINDOWS: {
                        return (input.version.equals("") || input.version.equals("2008") || input.version.equals("2008 R2")) && input.is64Bit;
                    }
                }
                return false;
            }
        });
    }

    @Test
    public void testDefaultTemplateBuilder() throws IOException {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        Assert.assertEquals((String)defaultTemplate.getImage().getId(), (String)"Ubuntu 12.04 x64");
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"12.04");
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
        Assert.assertEquals((int)defaultTemplate.getHardware().getRam(), (int)768);
        Assert.assertEquals((String)defaultTemplate.getHardware().getHypervisor(), (String)"Xen");
        Assert.assertEquals((Object)ComputeServiceUtils.getSpace((Hardware)defaultTemplate.getHardware()), (Object)5.0);
        Assert.assertEquals((Object)((Volume)defaultTemplate.getHardware().getVolumes().get(0)).getType(), (Object)Volume.Type.LOCAL);
        Assert.assertEquals(defaultTemplate.getOptions().getClass(), GleSYSTemplateOptions.class);
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of((Object)"NL-NH", (Object)"SE-N", (Object)"US-NY", (Object)"SE-AB");
    }
}

