/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class DomainRecord {
    private final String id;
    private final String domainname;
    private final String host;
    private final String type;
    private final String data;
    private final int ttl;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromDomainRecord(this);
    }

    @ConstructorProperties(value={"recordid", "domainname", "host", "type", "data", "ttl"})
    protected DomainRecord(@Nullable String id, String domainname, String host, String type, @Nullable String data, int ttl) {
        this.id = id;
        this.domainname = (String)Preconditions.checkNotNull((Object)domainname, (Object)"domainname");
        this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.data = data;
        this.ttl = ttl;
    }

    public String getId() {
        return this.id;
    }

    public String getname() {
        return this.domainname;
    }

    public String getHost() {
        return this.host;
    }

    public String getType() {
        return this.type;
    }

    @Nullable
    public String getData() {
        return this.data;
    }

    public int getTtl() {
        return this.ttl;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DomainRecord that = (DomainRecord)DomainRecord.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("domainname", (Object)this.domainname).add("host", (Object)this.host).add("type", (Object)this.type).add("data", (Object)this.data).add("ttl", this.ttl);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String domainname;
        protected String host;
        protected String type;
        protected String data;
        protected int ttl;

        protected abstract T self();

        public T id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this.self();
        }

        public T domainname(String domainname) {
            this.domainname = (String)Preconditions.checkNotNull((Object)domainname, (Object)"domainname");
            return this.self();
        }

        public T host(String host) {
            this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
            return this.self();
        }

        public T type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            return this.self();
        }

        public T data(String data) {
            this.data = (String)Preconditions.checkNotNull((Object)data, (Object)"data");
            return this.self();
        }

        public T ttl(int ttl) {
            this.ttl = ttl;
            return this.self();
        }

        public DomainRecord build() {
            return new DomainRecord(this.id, this.domainname, this.host, this.type, this.data, this.ttl);
        }

        public T fromDomainRecord(DomainRecord in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).domainname(in.getname())).host(in.getHost())).type(in.getType())).data(in.getData())).ttl(in.getTtl());
        }
    }
}

