/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.collect.FluentIterable;
import java.util.Map;
import java.util.SortedMap;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.glesys.domain.AllowedArgumentsForCreateServer;
import org.jclouds.glesys.domain.Console;
import org.jclouds.glesys.domain.OSTemplate;
import org.jclouds.glesys.domain.ResourceUsage;
import org.jclouds.glesys.domain.Server;
import org.jclouds.glesys.domain.ServerDetails;
import org.jclouds.glesys.domain.ServerLimit;
import org.jclouds.glesys.domain.ServerSpec;
import org.jclouds.glesys.domain.ServerStatus;
import org.jclouds.glesys.functions.ParseTemplatesFromHttpResponse;
import org.jclouds.glesys.options.CloneServerOptions;
import org.jclouds.glesys.options.CreateServerOptions;
import org.jclouds.glesys.options.DestroyServerOptions;
import org.jclouds.glesys.options.ServerStatusOptions;
import org.jclouds.glesys.options.UpdateServerOptions;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={BasicAuthentication.class})
public interface ServerApi {
    @Named(value="server:list")
    @POST
    @Path(value="/server/list/format/json")
    @SelectJson(value={"servers"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<Server> list();

    @Named(value="server:details")
    @POST
    @Path(value="/server/details/format/json")
    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    @FormParams(keys={"includestate"}, values={"true"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ServerDetails get(@FormParam(value="serverid") String var1);

    @Named(value="server:status")
    @POST
    @Path(value="/server/status/format/json")
    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ServerStatus getStatus(@FormParam(value="serverid") String var1, ServerStatusOptions ... var2);

    @Named(value="server:limits")
    @POST
    @Path(value="/server/limits/format/json")
    @SelectJson(value={"limits"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public SortedMap<String, ServerLimit> getLimits(@FormParam(value="serverid") String var1);

    @Named(value="server:console")
    @POST
    @Path(value="/server/console/format/json")
    @SelectJson(value={"console"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Console getConsole(@FormParam(value="serverid") String var1);

    @Named(value="server:allowedarguments")
    @GET
    @Path(value="/server/allowedarguments/format/json")
    @SelectJson(value={"argumentslist"})
    @Consumes(value={"application/json"})
    public Map<String, AllowedArgumentsForCreateServer> getAllowedArgumentsForCreateByPlatform();

    @Named(value="server:templates")
    @GET
    @Path(value="/server/templates/format/json")
    @ResponseParser(value=ParseTemplatesFromHttpResponse.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    public FluentIterable<OSTemplate> listTemplates();

    @Named(value="server:resetlimit")
    @POST
    @Path(value="/server/resetlimit/format/json")
    @Consumes(value={"application/json"})
    public SortedMap<String, ServerLimit> resetLimit(@FormParam(value="serverid") String var1, @FormParam(value="type") String var2);

    @Named(value="server:reboot")
    @POST
    @SelectJson(value={"server"})
    @Path(value="/server/reboot/format/json")
    @Consumes(value={"application/json"})
    public ServerDetails reboot(@FormParam(value="serverid") String var1);

    @Named(value="server:start")
    @POST
    @SelectJson(value={"server"})
    @Path(value="/server/start/format/json")
    @Consumes(value={"application/json"})
    public ServerDetails start(@FormParam(value="serverid") String var1);

    @Named(value="server:stop")
    @POST
    @SelectJson(value={"server"})
    @Path(value="/server/stop/format/json")
    @Consumes(value={"application/json"})
    public ServerDetails stop(@FormParam(value="serverid") String var1);

    @Named(value="server:stop:hard")
    @POST
    @SelectJson(value={"server"})
    @Path(value="/server/stop/format/json")
    @FormParams(keys={"type"}, values={"hard"})
    @Consumes(value={"application/json"})
    public ServerDetails hardStop(@FormParam(value="serverid") String var1);

    @Named(value="server:create")
    @POST
    @SelectJson(value={"server"})
    @Path(value="/server/create/format/json")
    @Consumes(value={"application/json"})
    @MapBinder(value=CreateServerOptions.class)
    public ServerDetails createWithHostnameAndRootPassword(ServerSpec var1, @PayloadParam(value="hostname") String var2, @PayloadParam(value="rootpassword") String var3, CreateServerOptions ... var4);

    @Named(value="server:clone")
    @POST
    @Path(value="/server/clone/format/json")
    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    public ServerDetails clone(@FormParam(value="serverid") String var1, @FormParam(value="hostname") String var2, CloneServerOptions ... var3);

    @Named(value="server:edit")
    @POST
    @Path(value="/server/edit/format/json")
    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    public ServerDetails update(@FormParam(value="serverid") String var1, UpdateServerOptions var2);

    @Named(value="server:destroy")
    @POST
    @Path(value="/server/destroy/format/json")
    public void destroy(@FormParam(value="serverid") String var1, DestroyServerOptions var2);

    @Named(value="server:resetpassword")
    @POST
    @Path(value="/server/resetpassword/format/json")
    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    public ServerDetails resetPassword(@FormParam(value="serverid") String var1, @FormParam(value="rootpassword") String var2);

    @Named(value="server:resourceusage")
    @POST
    @Path(value="/server/resourceusage/format/json")
    @SelectJson(value={"usage"})
    @Consumes(value={"application/json"})
    public ResourceUsage getResourceUsage(@FormParam(value="serverid") String var1, @FormParam(value="resource") String var2, @FormParam(value="resolution") String var3);
}

