/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.glesys.domain.ResourceStatus;
import org.jclouds.glesys.domain.Server;
import org.jclouds.glesys.domain.ServerUptime;
import org.jclouds.javax.annotation.Nullable;

public class ServerStatus {
    private final Server.State state;
    private final ResourceStatus cpu;
    private final ResourceStatus memory;
    private final ResourceStatus disk;
    private final ServerUptime uptime;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerStatus(this);
    }

    @ConstructorProperties(value={"state", "cpu", "memory", "disk", "uptime"})
    protected ServerStatus(Server.State state, @Nullable ResourceStatus cpu, @Nullable ResourceStatus memory, @Nullable ResourceStatus disk, @Nullable ServerUptime uptime) {
        this.state = (Server.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
        this.cpu = cpu;
        this.memory = memory;
        this.disk = disk;
        this.uptime = uptime;
    }

    @Nullable
    public Server.State getState() {
        return this.state;
    }

    @Nullable
    public ResourceStatus getCpu() {
        return this.cpu;
    }

    @Nullable
    public ResourceStatus getMemory() {
        return this.memory;
    }

    @Nullable
    public ResourceStatus getDisk() {
        return this.disk;
    }

    @Nullable
    public ServerUptime getUptime() {
        return this.uptime;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.state, this.cpu, this.memory, this.disk, this.uptime});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerStatus that = (ServerStatus)ServerStatus.class.cast(obj);
        return Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)this.cpu, (Object)that.cpu) && Objects.equal((Object)this.memory, (Object)that.memory) && Objects.equal((Object)this.disk, (Object)that.disk) && Objects.equal((Object)this.uptime, (Object)that.uptime);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("state", (Object)this.state).add("cpu", (Object)this.cpu).add("memory", (Object)this.memory).add("disk", (Object)this.disk).add("uptime", (Object)this.uptime);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Server.State state;
        protected ResourceStatus cpu;
        protected ResourceStatus memory;
        protected ResourceStatus disk;
        protected ServerUptime uptime;

        protected abstract T self();

        public T state(Server.State state) {
            this.state = (Server.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
            return this.self();
        }

        public T cpu(ResourceStatus cpu) {
            this.cpu = (ResourceStatus)Preconditions.checkNotNull((Object)cpu, (Object)"cpu");
            return this.self();
        }

        public T memory(ResourceStatus memory) {
            this.memory = (ResourceStatus)Preconditions.checkNotNull((Object)memory, (Object)"memory");
            return this.self();
        }

        public T disk(ResourceStatus disk) {
            this.disk = (ResourceStatus)Preconditions.checkNotNull((Object)disk, (Object)"disk");
            return this.self();
        }

        public T uptime(ServerUptime uptime) {
            this.uptime = (ServerUptime)Preconditions.checkNotNull((Object)uptime, (Object)"uptime");
            return this.self();
        }

        public ServerStatus build() {
            return new ServerStatus(this.state, this.cpu, this.memory, this.disk, this.uptime);
        }

        public T fromServerStatus(ServerStatus in) {
            return ((Builder)((Builder)((Builder)((Builder)this.state(in.getState())).cpu(in.getCpu())).memory(in.getMemory())).disk(in.getDisk())).uptime(in.getUptime());
        }
    }
}

