/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.glance.v1_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.glance.v1_0.domain.ContainerFormat;
import org.jclouds.openstack.glance.v1_0.domain.DiskFormat;
import org.jclouds.openstack.glance.v1_0.domain.Image;
import org.jclouds.openstack.v2_0.domain.Link;

public class ImageDetails
extends Image {
    @Named(value="min_disk")
    private final long minDisk;
    @Named(value="min_ram")
    private final long minRam;
    private final Optional<String> location;
    private final Optional<String> owner;
    @Named(value="updated_at")
    private final Date updatedAt;
    @Named(value="created_at")
    private final Date createdAt;
    @Named(value="deleted_at")
    private final Optional<Date> deletedAt;
    private final Image.Status status;
    @Named(value="is_public")
    private final boolean isPublic;
    private final Map<String, String> properties;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    @Override
    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromImageDetails(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "container_format", "disk_format", "size", "checksum", "min_disk", "min_ram", "location", "owner", "updated_at", "created_at", "deleted_at", "status", "is_public", "properties"})
    protected ImageDetails(String id, @Nullable String name, Set<Link> links, @Nullable ContainerFormat containerFormat, @Nullable DiskFormat diskFormat, @Nullable Long size, @Nullable String checksum, long minDisk, long minRam, @Nullable String location, @Nullable String owner, Date updatedAt, Date createdAt, @Nullable Date deletedAt, Image.Status status, boolean isPublic, Map<String, String> properties) {
        super(id, name, links, containerFormat, diskFormat, size, checksum);
        this.minDisk = minDisk;
        this.minRam = minRam;
        this.location = Optional.fromNullable((Object)location);
        this.owner = Optional.fromNullable((Object)owner);
        this.updatedAt = (Date)Preconditions.checkNotNull((Object)updatedAt, (Object)"updatedAt");
        this.createdAt = (Date)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
        this.deletedAt = Optional.fromNullable((Object)deletedAt);
        this.status = (Image.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.isPublic = isPublic;
        this.properties = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(properties, (Object)"properties")));
    }

    public long getMinDisk() {
        return this.minDisk;
    }

    public long getMinRam() {
        return this.minRam;
    }

    public Optional<String> getLocation() {
        return this.location;
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Optional<Date> getDeletedAt() {
        return this.deletedAt;
    }

    public Image.Status getStatus() {
        return this.status;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.minDisk, this.minRam, this.location, this.owner, this.updatedAt, this.createdAt, this.deletedAt, this.status, this.isPublic, this.properties});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ImageDetails that = (ImageDetails)((Object)ImageDetails.class.cast(obj));
        return super.equals((Object)that) && Objects.equal((Object)this.minDisk, (Object)that.minDisk) && Objects.equal((Object)this.minRam, (Object)that.minRam) && Objects.equal(this.location, that.location) && Objects.equal(this.owner, that.owner) && Objects.equal((Object)this.updatedAt, (Object)that.updatedAt) && Objects.equal((Object)this.createdAt, (Object)that.createdAt) && Objects.equal(this.deletedAt, that.deletedAt) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)this.isPublic, (Object)that.isPublic) && Objects.equal(this.properties, that.properties);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("minDisk", this.minDisk).add("minRam", this.minRam).add("location", this.location).add("owner", this.owner).add("updatedAt", (Object)this.updatedAt).add("createdAt", (Object)this.createdAt).add("deletedAt", this.deletedAt).add("status", (Object)this.status).add("isPublic", this.isPublic).add("properties", this.properties);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Image.Builder<T> {
        protected long minDisk;
        protected long minRam;
        protected String location;
        protected String owner;
        protected Date updatedAt;
        protected Date createdAt;
        protected Date deletedAt;
        protected Image.Status status;
        protected boolean isPublic;
        protected Map<String, String> properties = ImmutableMap.of();

        public T minDisk(long minDisk) {
            this.minDisk = minDisk;
            return (T)((Object)((Builder)this.self()));
        }

        public T minRam(long minRam) {
            this.minRam = minRam;
            return (T)((Object)((Builder)this.self()));
        }

        public T location(String location) {
            this.location = location;
            return (T)((Object)((Builder)this.self()));
        }

        public T owner(String owner) {
            this.owner = owner;
            return (T)((Object)((Builder)this.self()));
        }

        public T updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return (T)((Object)((Builder)this.self()));
        }

        public T createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return (T)((Object)((Builder)this.self()));
        }

        public T deletedAt(Date deletedAt) {
            this.deletedAt = deletedAt;
            return (T)((Object)((Builder)this.self()));
        }

        public T status(Image.Status status) {
            this.status = status;
            return (T)((Object)((Builder)this.self()));
        }

        public T isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return (T)((Object)((Builder)this.self()));
        }

        public T properties(Map<String, String> properties) {
            this.properties = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(properties, (Object)"properties")));
            return (T)((Object)((Builder)this.self()));
        }

        @Override
        public ImageDetails build() {
            return new ImageDetails(this.id, this.name, this.links, this.containerFormat, this.diskFormat, this.size, this.checksum, this.minDisk, this.minRam, this.location, this.owner, this.updatedAt, this.createdAt, this.deletedAt, this.status, this.isPublic, this.properties);
        }

        public T fromImageDetails(ImageDetails in) {
            return ((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)super.fromImage(in))).minDisk(in.getMinDisk()))).minRam(in.getMinRam()))).location((String)in.getLocation().orNull()))).owner((String)in.getOwner().orNull()))).updatedAt(in.getUpdatedAt()))).createdAt(in.getCreatedAt()))).deletedAt((Date)in.getDeletedAt().orNull()))).status(in.getStatus()))).isPublic(in.isPublic()))).properties(in.getProperties());
        }
    }
}

