/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.features;

import com.google.inject.name.Named;
import java.io.Closeable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.digitalocean.domain.Image;
import org.jclouds.digitalocean.http.filters.AuthenticationFilter;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@Consumes(value={"application/json"})
@Path(value="/images")
public interface ImageApi
extends Closeable {
    @Named(value="image:list")
    @GET
    @SelectJson(value={"images"})
    public List<Image> list();

    @Named(value="image:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"image"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Image get(@PathParam(value="id") int var1);

    @Named(value="image:get")
    @GET
    @Path(value="/{slug}")
    @SelectJson(value={"image"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Image get(@PathParam(value="slug") String var1);

    @Named(value="image:delete")
    @GET
    @Path(value="/{id}/destroy")
    public void delete(@PathParam(value="id") int var1);

    @Named(value="image:delete")
    @GET
    @Path(value="/{slug}/destroy")
    public void delete(@PathParam(value="slug") String var1);

    @Named(value="image:transfer")
    @GET
    @Path(value="/{id}/transfer")
    @SelectJson(value={"event_id"})
    public int transfer(@PathParam(value="id") int var1, @QueryParam(value="region_id") int var2);

    @Named(value="image:transfer")
    @GET
    @Path(value="/{slug}/transfer")
    @SelectJson(value={"event_id"})
    public int transfer(@PathParam(value="slug") String var1, @QueryParam(value="region_id") int var2);
}

