/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.domain;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Region {
    private final int id;
    private final String name;
    private final String slug;

    @ConstructorProperties(value={"id", "name", "slug"})
    public Region(int id, String name, String slug) {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.slug = (String)Preconditions.checkNotNull((Object)slug, (Object)"slug cannot be null");
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSlug() {
        return this.slug;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.slug == null ? 0 : this.slug.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Region other = (Region)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.slug == null ? other.slug != null : !this.slug.equals(other.slug));
    }

    public String toString() {
        return "Region [id=" + this.id + ", name=" + this.name + ", slug=" + this.slug + "]";
    }
}

