/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.digitalocean.domain.Distribution;

public class OperatingSystem {
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\s(\\d+(?:\\.?\\d+)?)");
    private static final Pattern ARCH_PATTERN = Pattern.compile("x\\d{2}");
    private static final String IS_64_BIT = "x64";
    private final Distribution distribution;
    private final String version;
    private final String arch;

    private OperatingSystem(String distribution, String version, String arch) {
        this.distribution = (Distribution)((Object)Preconditions.checkNotNull((Object)((Object)Distribution.fromValue(distribution)), (Object)"distribution cannot be null"));
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version cannot be null");
        this.arch = (String)Preconditions.checkNotNull((Object)arch, (Object)"arch cannot be null");
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean is64bit() {
        return IS_64_BIT.equals(this.arch);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String match(Pattern pattern, String input, int group) {
        Matcher m = pattern.matcher(input);
        return m.find() ? Strings.nullToEmpty((String)m.group(group)) : "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arch == null ? 0 : this.arch.hashCode());
        result = 31 * result + (this.distribution == null ? 0 : this.distribution.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        if (this.arch == null ? other.arch != null : !this.arch.equals(other.arch)) {
            return false;
        }
        if (this.distribution != other.distribution) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "OperatingSystem [distribution=" + (Object)((Object)this.distribution) + ", version=" + this.version + ", arch=" + this.arch + "]";
    }

    public static class Builder {
        private String name;
        private String distribution;

        public Builder from(String name, String distribution) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
            this.distribution = (String)Preconditions.checkNotNull((Object)distribution, (Object)"distribution cannot be null");
            return this;
        }

        public OperatingSystem build() {
            return new OperatingSystem(this.distribution, OperatingSystem.match(VERSION_PATTERN, this.name, 1), OperatingSystem.match(ARCH_PATTERN, this.name, 0));
        }
    }
}

