/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.domain;

import com.google.common.base.Preconditions;
import com.google.inject.name.Named;
import java.beans.ConstructorProperties;

public class DropletCreation {
    private final int id;
    private final String name;
    @Named(value="image_id")
    private final int imageId;
    @Named(value="size_id")
    private final int sizeId;
    @Named(value="event_id")
    private final int eventId;

    @ConstructorProperties(value={"id", "name", "image_id", "size_id", "event_id"})
    public DropletCreation(int id, String name, int imageId, int sizeId, int eventId) {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.imageId = imageId;
        this.sizeId = sizeId;
        this.eventId = eventId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getImageId() {
        return this.imageId;
    }

    public int getSizeId() {
        return this.sizeId;
    }

    public int getEventId() {
        return this.eventId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.eventId;
        result = 31 * result + this.id;
        result = 31 * result + this.imageId;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.sizeId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DropletCreation other = (DropletCreation)obj;
        if (this.eventId != other.eventId) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.imageId != other.imageId) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.sizeId == other.sizeId;
    }

    public String toString() {
        return "DropletCreation [id=" + this.id + ", name=" + this.name + ", imageId=" + this.imageId + ", sizeId=" + this.sizeId + ", eventId=" + this.eventId + "]";
    }
}

