/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.digitalocean.ssh.DSAKeys;
import org.jclouds.json.config.GsonModule;
import org.jclouds.ssh.SshKeys;

public class DigitalOceanParserModule
extends AbstractModule {
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public Function<PublicKey, String> publicKeyToSshKey() {
        return new Function<PublicKey, String>(){

            public String apply(PublicKey input) {
                if (input instanceof RSAPublicKey) {
                    return SshKeys.encodeAsOpenSSH((RSAPublicKey)((RSAPublicKey)input));
                }
                if (input instanceof DSAPublicKey) {
                    return DSAKeys.encodeAsOpenSSH((DSAPublicKey)input);
                }
                throw new IllegalArgumentException("Only RSA and DSA keys are supported");
            }
        };
    }

    @Provides
    @Singleton
    public Function<String, PublicKey> sshKeyToPublicKey() {
        return new Function<String, PublicKey>(){

            public PublicKey apply(String input) {
                Iterable parts = Splitter.on((char)' ').split((CharSequence)input);
                Preconditions.checkArgument((Iterables.size((Iterable)parts) >= 2 ? 1 : 0) != 0, (Object)"bad format, should be: [ssh-rsa|ssh-dss] AAAAB3...");
                String type = (String)Iterables.get((Iterable)parts, (int)0);
                try {
                    if ("ssh-rsa".equals(type)) {
                        RSAPublicKeySpec spec = SshKeys.publicKeySpecFromOpenSSH((String)input);
                        return KeyFactory.getInstance("RSA").generatePublic(spec);
                    }
                    if ("ssh-dss".equals(type)) {
                        DSAPublicKeySpec spec = DSAKeys.publicKeySpecFromOpenSSH(input);
                        return KeyFactory.getInstance("DSA").generatePublic(spec);
                    }
                    throw new IllegalArgumentException("bad format, should be: [ssh-rsa|ssh-dss] AAAAB3...");
                }
                catch (InvalidKeySpecException ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        };
    }

    @Provides
    @Singleton
    public Map<Type, Object> provideCustomAdapterBindings(SshPublicKeyAdapter sshPublicKeyAdapter) {
        return ImmutableMap.of(PublicKey.class, (Object)((Object)sshPublicKeyAdapter));
    }

    @Singleton
    public static class SshPublicKeyAdapter
    extends TypeAdapter<PublicKey> {
        private final Function<PublicKey, String> publicKeyToSshKey;
        private final Function<String, PublicKey> sshKeyToPublicKey;

        @Inject
        public SshPublicKeyAdapter(Function<PublicKey, String> publicKeyToSshKey, Function<String, PublicKey> sshKeyToPublicKey) {
            this.publicKeyToSshKey = (Function)Preconditions.checkNotNull(publicKeyToSshKey, (Object)"publicKeyToSshKey cannot be null");
            this.sshKeyToPublicKey = (Function)Preconditions.checkNotNull(sshKeyToPublicKey, (Object)"sshKeyToPublicKey cannot be null");
        }

        public void write(JsonWriter out, PublicKey value) throws IOException {
            out.value((String)this.publicKeyToSshKey.apply((Object)value));
        }

        public PublicKey read(JsonReader in) throws IOException {
            return (PublicKey)this.sshKeyToPublicKey.apply((Object)in.nextString().trim());
        }
    }
}

