/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.config;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.handlers.DigitalOceanErrorHandler;
import org.jclouds.digitalocean.http.ResponseStatusFromPayloadHttpCommandExecutorService;
import org.jclouds.digitalocean.strategy.ListSshKeys;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.config.SSLModule;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class DigitalOceanHttpApiModule
extends HttpApiModule<DigitalOceanApi> {
    protected void configure() {
        super.configure();
        this.install(new FactoryModuleBuilder().build(ListSshKeys.Factory.class));
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(DigitalOceanErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(DigitalOceanErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(DigitalOceanErrorHandler.class);
    }

    @ConfiguresHttpCommandExecutorService
    public static class DigitalOceanHttpCommandExecutorServiceModule
    extends AbstractModule {
        protected void configure() {
            this.install((Module)new SSLModule());
            this.bind(HttpCommandExecutorService.class).to(ResponseStatusFromPayloadHttpCommandExecutorService.class).in(Scopes.SINGLETON);
        }
    }
}

