/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.functions.TemplateOptionsToStatement;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.compute.extensions.DigitalOceanImageExtension;
import org.jclouds.digitalocean.compute.functions.DropletStatusToStatus;
import org.jclouds.digitalocean.compute.functions.DropletToNodeMetadata;
import org.jclouds.digitalocean.compute.functions.ImageToImage;
import org.jclouds.digitalocean.compute.functions.RegionToLocation;
import org.jclouds.digitalocean.compute.functions.SizeToHardware;
import org.jclouds.digitalocean.compute.functions.TemplateOptionsToStatementWithoutPublicKey;
import org.jclouds.digitalocean.compute.options.DigitalOceanTemplateOptions;
import org.jclouds.digitalocean.compute.strategy.CreateKeyPairsThenCreateNodes;
import org.jclouds.digitalocean.compute.strategy.DigitalOceanComputeServiceAdapter;
import org.jclouds.digitalocean.domain.Droplet;
import org.jclouds.digitalocean.domain.Event;
import org.jclouds.digitalocean.domain.Image;
import org.jclouds.digitalocean.domain.Region;
import org.jclouds.digitalocean.domain.Size;
import org.jclouds.domain.Location;
import org.jclouds.util.Predicates2;

public class DigitalOceanComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Droplet, Size, Image, Region> {
    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<Droplet, Size, Image, Region>>(){}).to(DigitalOceanComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Droplet, NodeMetadata>>(){}).to(DropletToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(ImageToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Region, Location>>(){}).to(RegionToLocation.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Size, Hardware>>(){}).to(SizeToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Droplet.Status, NodeMetadata.Status>>(){}).to(DropletStatusToStatus.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<Droplet, Size, Image, Region>(){});
        this.bind(CreateNodesInGroupThenAddToSet.class).to(CreateKeyPairsThenCreateNodes.class);
        this.bind(TemplateOptions.class).to(DigitalOceanTemplateOptions.class);
        this.bind(TemplateOptionsToStatement.class).to(TemplateOptionsToStatementWithoutPublicKey.class);
        this.bind((TypeLiteral)new TypeLiteral<ImageExtension>(){}).to(DigitalOceanImageExtension.class);
    }

    protected Optional<ImageExtension> provideImageExtension(Injector i) {
        return Optional.of((Object)i.getInstance(ImageExtension.class));
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.node-running")
    protected Predicate<Integer> provideDropletRunningPredicate(DigitalOceanApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new EventDonePredicate(api), (long)timeouts.nodeRunning, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.node-suspended")
    protected Predicate<Integer> provideDropletSuspendedPredicate(DigitalOceanApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new EventDonePredicate(api), (long)timeouts.nodeSuspended, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.node-terminated")
    protected Predicate<Integer> provideDropletTerminatedPredicate(DigitalOceanApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new EventDonePredicate(api), (long)timeouts.nodeTerminated, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.image-available")
    protected Predicate<Integer> provideImageAvailablePredicate(DigitalOceanApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new EventDonePredicate(api), (long)timeouts.imageAvailable, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @VisibleForTesting
    static class EventDonePredicate
    implements Predicate<Integer> {
        private final DigitalOceanApi api;

        public EventDonePredicate(DigitalOceanApi api) {
            this.api = (DigitalOceanApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
        }

        public boolean apply(Integer input) {
            Event event = this.api.getEventApi().get(input);
            switch (event.getStatus()) {
                case DONE: {
                    return true;
                }
                case PENDING: {
                    return false;
                }
            }
            throw new IllegalStateException("Resource is in invalid status: " + event.getStatus().name());
        }
    }
}

