/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.domain.options;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class CreateDropletOptions
extends BaseHttpRequestOptions {
    private final Set<Integer> sshKeyIds;
    private final Boolean privateNetworking;
    private final Boolean backupsEnabled;

    public CreateDropletOptions(Set<Integer> sshKeyIds, Boolean privateNetworking, Boolean backupsEnabled) {
        this.sshKeyIds = sshKeyIds;
        this.privateNetworking = privateNetworking;
        this.backupsEnabled = backupsEnabled;
        if (!sshKeyIds.isEmpty()) {
            this.queryParameters.put((Object)"ssh_key_ids", (Object)Joiner.on((char)',').join(sshKeyIds));
        }
        if (privateNetworking != null) {
            this.queryParameters.put((Object)"private_networking", (Object)privateNetworking.toString());
        }
        if (backupsEnabled != null) {
            this.queryParameters.put((Object)"backups_enabled", (Object)backupsEnabled.toString());
        }
    }

    public Iterable<Integer> getSshKeyIds() {
        return this.sshKeyIds;
    }

    public Boolean getPrivateNetworking() {
        return this.privateNetworking;
    }

    public Boolean getBackupsEnabled() {
        return this.backupsEnabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.backupsEnabled == null ? 0 : this.backupsEnabled.hashCode());
        result = 31 * result + (this.privateNetworking == null ? 0 : this.privateNetworking.hashCode());
        result = 31 * result + (this.sshKeyIds == null ? 0 : ((Object)this.sshKeyIds).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CreateDropletOptions other = (CreateDropletOptions)((Object)obj);
        if (this.backupsEnabled == null ? other.backupsEnabled != null : !this.backupsEnabled.equals(other.backupsEnabled)) {
            return false;
        }
        if (this.privateNetworking == null ? other.privateNetworking != null : !this.privateNetworking.equals(other.privateNetworking)) {
            return false;
        }
        return !(this.sshKeyIds == null ? other.sshKeyIds != null : !((Object)this.sshKeyIds).equals(other.sshKeyIds));
    }

    public String toString() {
        return "CreateDropletOptions [sshKeyIds=" + this.sshKeyIds + ", privateNetworking=" + this.privateNetworking + ", backupsEnabled=" + this.backupsEnabled + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableSet.Builder<Integer> sshKeyIds = ImmutableSet.builder();
        private Boolean privateNetworking;
        private Boolean backupsEnabled;

        public Builder addSshKeyIds(Iterable<Integer> sshKeyIds) {
            this.sshKeyIds.addAll(sshKeyIds);
            return this;
        }

        public Builder addSshKeyId(int sshKeyId) {
            this.sshKeyIds.add((Object)sshKeyId);
            return this;
        }

        public Builder privateNetworking(boolean privateNetworking) {
            this.privateNetworking = privateNetworking;
            return this;
        }

        public Builder backupsEnabled(boolean backupsEnabled) {
            this.backupsEnabled = backupsEnabled;
            return this;
        }

        public CreateDropletOptions build() {
            return new CreateDropletOptions((Set<Integer>)this.sshKeyIds.build(), this.privateNetworking, this.backupsEnabled);
        }
    }
}

