/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.domain;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;

public class Size {
    private final int id;
    private final String name;
    private final String slug;
    private final int memory;
    private final int cpu;
    private final int disk;
    @Named(value="cost_per_hour")
    private final String costPerHour;
    @Named(value="cost_per_month")
    private final String costPerMonth;

    @ConstructorProperties(value={"id", "name", "slug", "memory", "cpu", "disk", "cost_per_hour", "cost_per_month"})
    public Size(int id, String name, String slug, int memory, int cpu, int disk, String costPerHour, String costPerMonth) {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.slug = (String)Preconditions.checkNotNull((Object)slug, (Object)"slug");
        this.memory = memory;
        this.cpu = cpu;
        this.disk = disk;
        this.costPerHour = (String)Preconditions.checkNotNull((Object)costPerHour, (Object)"costPerHour cannot be null");
        this.costPerMonth = (String)Preconditions.checkNotNull((Object)costPerMonth, (Object)"costPerMonth cannot be null");
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSlug() {
        return this.slug;
    }

    public int getMemory() {
        return this.memory;
    }

    public int getCpu() {
        return this.cpu;
    }

    public int getDisk() {
        return this.disk;
    }

    public String getCostPerHour() {
        return this.costPerHour;
    }

    public String getCostPerMonth() {
        return this.costPerMonth;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.costPerHour == null ? 0 : this.costPerHour.hashCode());
        result = prime * result + (this.costPerMonth == null ? 0 : this.costPerMonth.hashCode());
        result = prime * result + this.cpu;
        result = prime * result + this.disk;
        result = prime * result + this.id;
        result = prime * result + this.memory;
        result = prime * result + (this.name == null ? 0 : this.name.hashCode());
        result = prime * result + (this.slug == null ? 0 : this.slug.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Size other = (Size)obj;
        if (this.costPerHour == null ? other.costPerHour != null : !this.costPerHour.equals(other.costPerHour)) {
            return false;
        }
        if (this.costPerMonth == null ? other.costPerMonth != null : !this.costPerMonth.equals(other.costPerMonth)) {
            return false;
        }
        if (this.cpu != other.cpu) {
            return false;
        }
        if (this.disk != other.disk) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.memory != other.memory) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.slug == null ? other.slug != null : !this.slug.equals(other.slug));
    }

    public String toString() {
        return "Size [id=" + this.id + ", name=" + this.name + ", slug=" + this.slug + ", memory=" + this.memory + ", cpu=" + this.cpu + ", disk=" + this.disk + ", costPerHour=" + this.costPerHour + ", costPerMonth=" + this.costPerMonth + "]";
    }
}

