/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;

public class DigitalOceanTemplateOptions
extends TemplateOptions
implements Cloneable {
    private Set<Integer> sshKeyIds = ImmutableSet.of();
    private Boolean privateNetworking;
    private Boolean backupsEnabled;

    public DigitalOceanTemplateOptions privateNetworking(boolean privateNetworking) {
        this.privateNetworking = privateNetworking;
        return this;
    }

    public DigitalOceanTemplateOptions backupsEnabled(boolean backupsEnabled) {
        this.backupsEnabled = backupsEnabled;
        return this;
    }

    public DigitalOceanTemplateOptions sshKeyIds(Iterable<Integer> sshKeyIds) {
        this.sshKeyIds = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(sshKeyIds, (Object)"sshKeyIds cannot be null")));
        return this;
    }

    public Set<Integer> getSshKeyIds() {
        return this.sshKeyIds;
    }

    public Boolean getPrivateNetworking() {
        return this.privateNetworking;
    }

    public Boolean getBackupsEnabled() {
        return this.backupsEnabled;
    }

    public DigitalOceanTemplateOptions clone() {
        DigitalOceanTemplateOptions options = new DigitalOceanTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof DigitalOceanTemplateOptions) {
            DigitalOceanTemplateOptions eTo = (DigitalOceanTemplateOptions)DigitalOceanTemplateOptions.class.cast(to);
            if (this.privateNetworking != null) {
                eTo.privateNetworking(this.privateNetworking);
            }
            if (this.backupsEnabled != null) {
                eTo.backupsEnabled(this.backupsEnabled);
            }
            eTo.sshKeyIds(this.sshKeyIds);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.backupsEnabled == null ? 0 : this.backupsEnabled.hashCode());
        result = 31 * result + (this.privateNetworking == null ? 0 : this.privateNetworking.hashCode());
        result = 31 * result + (this.sshKeyIds == null ? 0 : ((Object)this.sshKeyIds).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DigitalOceanTemplateOptions other = (DigitalOceanTemplateOptions)obj;
        if (this.backupsEnabled == null ? other.backupsEnabled != null : !this.backupsEnabled.equals(other.backupsEnabled)) {
            return false;
        }
        if (this.privateNetworking == null ? other.privateNetworking != null : !this.privateNetworking.equals(other.privateNetworking)) {
            return false;
        }
        return !(this.sshKeyIds == null ? other.sshKeyIds != null : !((Object)this.sshKeyIds).equals(other.sshKeyIds));
    }

    public Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = super.string().omitNullValues();
        toString.add("privateNetworking", (Object)this.privateNetworking);
        toString.add("backupsEnabled", (Object)this.backupsEnabled);
        if (!this.sshKeyIds.isEmpty()) {
            toString.add("sshKeyIds", this.sshKeyIds);
        }
        return toString;
    }

    public static class Builder {
        public static DigitalOceanTemplateOptions privateNetworking(boolean privateNetworking) {
            DigitalOceanTemplateOptions options = new DigitalOceanTemplateOptions();
            return options.privateNetworking(privateNetworking);
        }

        public static DigitalOceanTemplateOptions backupsEnabled(boolean backupsEnabled) {
            DigitalOceanTemplateOptions options = new DigitalOceanTemplateOptions();
            return options.backupsEnabled(backupsEnabled);
        }

        public static DigitalOceanTemplateOptions sshKeyIds(Iterable<Integer> sshKeyIds) {
            DigitalOceanTemplateOptions options = new DigitalOceanTemplateOptions();
            return options.sshKeyIds(sshKeyIds);
        }
    }
}

