/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.http;

import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.util.Properties;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.features.ImageApi;
import org.jclouds.digitalocean.internal.BaseDigitalOceanMockTest;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ResponseStatusFromPayloadHttpCommandExecutorServiceTest")
public class ResponseStatusFromPayloadHttpCommandExecutorServiceTest
extends BaseDigitalOceanMockTest {
    @Override
    protected Properties setupProperties() {
        Properties properties = super.setupProperties();
        properties.setProperty("jclouds.max-retries", "1");
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAccessDenied() throws Exception {
        MockWebServer server = ResponseStatusFromPayloadHttpCommandExecutorServiceTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/access-denied.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            imageApi.list();
            Assert.fail((String)"Request should have failed");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof AuthorizationException), (String)"Exception should be an AuthorizationException");
            Assert.assertEquals((String)ex.getMessage(), (String)"Access Denied");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotFound() throws Exception {
        MockWebServer server = ResponseStatusFromPayloadHttpCommandExecutorServiceTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/not-found.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            imageApi.list();
            Assert.fail((String)"Request should have failed");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof ResourceNotFoundException), (String)"Exception should be a ResourceNotFoundException");
            Assert.assertEquals((String)ex.getMessage(), (String)"Not Found");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInternalServerError() throws Exception {
        MockWebServer server = ResponseStatusFromPayloadHttpCommandExecutorServiceTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/error.json")));
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/error.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            imageApi.list();
            Assert.fail((String)"Request should have failed after retrying");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof HttpResponseException), (String)"Exception should be an HttpResponseException");
            HttpResponseException exception = (HttpResponseException)HttpResponseException.class.cast(ex);
            Assert.assertEquals((int)exception.getResponse().getStatusCode(), (int)500);
            Assert.assertEquals((String)exception.getMessage(), (String)"No Image Found");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }
}

