/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.features;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.Droplet;
import org.jclouds.digitalocean.domain.DropletCreation;
import org.jclouds.digitalocean.domain.Image;
import org.jclouds.digitalocean.domain.Size;
import org.jclouds.digitalocean.internal.BaseDigitalOceanLiveTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="DropletApiLiveTest")
public class DropletApiLiveTest
extends BaseDigitalOceanLiveTest {
    private DropletCreation dropletCreation;
    private DropletCreation dropletCreationUsingSlugs;
    private Droplet droplet;
    private Droplet dropletUsingSlugs;
    private Image snapshot;

    protected void initialize() {
        super.initialize();
        this.initializeImageSizeAndRegion();
    }

    @AfterClass
    public void cleanup() {
        int event;
        if (this.droplet != null) {
            event = ((DigitalOceanApi)this.api).getDropletApi().destroy(this.droplet.getId(), true);
            Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should not be null");
        }
        if (this.dropletUsingSlugs != null) {
            event = ((DigitalOceanApi)this.api).getDropletApi().destroy(this.dropletUsingSlugs.getId(), true);
            Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should not be null");
        }
        if (this.snapshot != null) {
            ((DigitalOceanApi)this.api).getImageApi().delete(this.snapshot.getId());
        }
    }

    public void testCreateDroplet() {
        this.dropletCreation = ((DigitalOceanApi)this.api).getDropletApi().create("droplettest", this.defaultImage.getId(), this.defaultSize.getId(), this.defaultRegion.getId());
        Assert.assertTrue((this.dropletCreation.getId() > 0 ? 1 : 0) != 0, (String)"Created droplet id should be > 0");
        Assert.assertTrue((this.dropletCreation.getEventId() > 0 ? 1 : 0) != 0, (String)"Droplet creation event id should be > 0");
    }

    public void testCreateDropletUsingSlugs() {
        this.dropletCreationUsingSlugs = ((DigitalOceanApi)this.api).getDropletApi().create("droplettestwithslugs", this.defaultImage.getSlug(), this.defaultSize.getSlug(), this.defaultRegion.getSlug());
        Assert.assertTrue((this.dropletCreationUsingSlugs.getId() > 0 ? 1 : 0) != 0, (String)"Created droplet id should be > 0");
        Assert.assertTrue((this.dropletCreationUsingSlugs.getEventId() > 0 ? 1 : 0) != 0, (String)"Droplet creation event id should be > 0");
    }

    @Test(dependsOnMethods={"testCreateDroplet", "testCreateDropletUsingSlugs"})
    public void testGetDroplet() {
        this.waitForEvent(this.dropletCreation.getEventId());
        this.waitForEvent(this.dropletCreationUsingSlugs.getEventId());
        this.droplet = ((DigitalOceanApi)this.api).getDropletApi().get(this.dropletCreation.getId());
        this.dropletUsingSlugs = ((DigitalOceanApi)this.api).getDropletApi().get(this.dropletCreationUsingSlugs.getId());
        Assert.assertNotNull((Object)this.droplet, (String)"Created droplet should not be null");
        Assert.assertNotNull((Object)this.dropletUsingSlugs, (String)"Created droplet using slugs should not be null");
    }

    @Test(dependsOnMethods={"testGetDroplet"})
    public void testListDroplets() {
        List droplets = ((DigitalOceanApi)this.api).getDropletApi().list();
        Assert.assertFalse((boolean)droplets.isEmpty(), (String)"Droplet list should not be empty");
    }

    @Test(dependsOnMethods={"testGetDroplet"})
    public void testPowerOffDroplet() {
        int event = ((DigitalOceanApi)this.api).getDropletApi().powerOff(this.droplet.getId());
        Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(event);
    }

    @Test(dependsOnMethods={"testPowerOffDroplet"})
    public void testPowerOnDroplet() {
        int event = ((DigitalOceanApi)this.api).getDropletApi().powerOn(this.droplet.getId());
        Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(event);
    }

    @Test(dependsOnMethods={"testPowerOnDroplet"})
    public void testRebootDroplet() {
        int event = ((DigitalOceanApi)this.api).getDropletApi().reboot(this.droplet.getId());
        Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(event);
    }

    @Test(dependsOnMethods={"testRebootDroplet"})
    public void testPowerCycleDroplet() {
        int event = ((DigitalOceanApi)this.api).getDropletApi().powerCycle(this.droplet.getId());
        Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(event);
    }

    @Test(dependsOnMethods={"testPowerCycleDroplet"})
    public void testResetPasswordForDroplet() {
        int event = ((DigitalOceanApi)this.api).getDropletApi().resetPassword(this.droplet.getId());
        Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(event);
    }

    @Test(dependsOnMethods={"testResetPasswordForDroplet"})
    public void testRenameDroplet() {
        int event = ((DigitalOceanApi)this.api).getDropletApi().rename(this.droplet.getId(), "droplettestupdated");
        Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(event);
        this.droplet = ((DigitalOceanApi)this.api).getDropletApi().get(this.droplet.getId());
        Assert.assertEquals((String)this.droplet.getName(), (String)"droplettestupdated", (String)"The renamed droplet should have the new name");
    }

    @Test(dependsOnMethods={"testRenameDroplet"})
    public void testRebuildDroplet() {
        int event = ((DigitalOceanApi)this.api).getDropletApi().rebuild(this.droplet.getId(), this.defaultImage.getId());
        Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(event);
    }

    @Test(dependsOnMethods={"testRebuildDroplet"})
    public void testRestoreDroplet() {
        int event = ((DigitalOceanApi)this.api).getDropletApi().restore(this.droplet.getId(), this.defaultImage.getId());
        Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(event);
    }

    @Test(dependsOnMethods={"testRestoreDroplet"})
    public void testSnapshotDroplet() {
        int powerOffEvent = ((DigitalOceanApi)this.api).getDropletApi().powerOff(this.droplet.getId());
        Assert.assertTrue((powerOffEvent > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(powerOffEvent);
        int event = ((DigitalOceanApi)this.api).getDropletApi().snapshot(this.droplet.getId(), "testsnapshot");
        Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(event);
        Optional snapshot = Iterables.tryFind((Iterable)((DigitalOceanApi)this.api).getImageApi().list(), (Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                return input.getName().equals("testsnapshot");
            }
        });
        Assert.assertTrue((boolean)snapshot.isPresent(), (String)"The created snapshot should exist in the image list");
        this.snapshot = (Image)snapshot.get();
    }

    @Test(dependsOnMethods={"testSnapshotDroplet"})
    public void testResizeDroplet() {
        int powerOffEvent = ((DigitalOceanApi)this.api).getDropletApi().powerOff(this.droplet.getId());
        Assert.assertTrue((powerOffEvent > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(powerOffEvent);
        Size newSize = (Size)this.sizes.get(1);
        int resizeEvent = ((DigitalOceanApi)this.api).getDropletApi().resize(this.droplet.getId(), newSize.getId());
        Assert.assertTrue((resizeEvent > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(resizeEvent);
    }

    @Test(dependsOnMethods={"testResizeDroplet"})
    public void testShutdownDroplet() {
        int event = ((DigitalOceanApi)this.api).getDropletApi().shutdown(this.droplet.getId());
        Assert.assertTrue((event > 0 ? 1 : 0) != 0, (String)"The event id should be > 0");
        this.waitForEvent(event);
    }
}

