/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.config;

import org.easymock.EasyMock;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.compute.config.DigitalOceanComputeServiceContextModule;
import org.jclouds.digitalocean.domain.Event;
import org.jclouds.digitalocean.features.EventApi;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EventDonePredicateTest")
public class EventDonePredicateTest {
    public void testEventProgress() {
        EventApi eventApi = (EventApi)EasyMock.createMock(EventApi.class);
        DigitalOceanApi api = (DigitalOceanApi)EasyMock.createMock(DigitalOceanApi.class);
        EasyMock.expect((Object)eventApi.get(1)).andReturn((Object)EventDonePredicateTest.event(Event.Status.DONE));
        EasyMock.expect((Object)eventApi.get(2)).andReturn((Object)EventDonePredicateTest.event(Event.Status.PENDING));
        EasyMock.expect((Object)api.getEventApi()).andReturn((Object)eventApi).times(2);
        EasyMock.replay((Object[])new Object[]{eventApi, api});
        DigitalOceanComputeServiceContextModule.EventDonePredicate predicate = new DigitalOceanComputeServiceContextModule.EventDonePredicate(api);
        Assert.assertTrue((boolean)predicate.apply(Integer.valueOf(1)));
        Assert.assertFalse((boolean)predicate.apply(Integer.valueOf(2)));
    }

    public void testEventFailed() {
        EventApi eventApi = (EventApi)EasyMock.createMock(EventApi.class);
        DigitalOceanApi api = (DigitalOceanApi)EasyMock.createMock(DigitalOceanApi.class);
        EasyMock.expect((Object)eventApi.get(EasyMock.anyInt())).andReturn((Object)EventDonePredicateTest.event(Event.Status.ERROR));
        EasyMock.expect((Object)api.getEventApi()).andReturn((Object)eventApi);
        EasyMock.replay((Object[])new Object[]{eventApi, api});
        DigitalOceanComputeServiceContextModule.EventDonePredicate predicate = new DigitalOceanComputeServiceContextModule.EventDonePredicate(api);
        try {
            predicate.apply(Integer.valueOf(1));
            Assert.fail((String)"Method should have thrown an IllegalStateException");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((String)ex.getMessage(), (String)"Resource is in invalid status: ERROR");
        }
    }

    private static Event event(Event.Status status) {
        return new Event(0, status, 0, "0", 0);
    }
}

