/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Module;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ContextBuilder;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.http.utils.Queries;
import org.jclouds.util.Strings2;
import org.testng.Assert;

public class BaseDigitalOceanMockTest {
    private final Set<Module> modules = ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()));
    protected String provider = "digitalocean";

    public DigitalOceanApi api(URL url) {
        return (DigitalOceanApi)ContextBuilder.newBuilder((String)this.provider).credentials("clientid", "apikey").endpoint(url.toString()).modules(this.modules).overrides(this.setupProperties()).buildApi(DigitalOceanApi.class);
    }

    protected Properties setupProperties() {
        return new Properties();
    }

    public static MockWebServer mockWebServer() throws IOException {
        MockWebServer server = new MockWebServer();
        server.play();
        return server;
    }

    public byte[] payloadFromResource(String resource) {
        try {
            return Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream(resource)).getBytes(Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected static void assertRequestHasCommonFields(RecordedRequest request, String path) throws InterruptedException {
        BaseDigitalOceanMockTest.assertRequestHasParameters(request, path, (Multimap<String, String>)ImmutableMultimap.of());
    }

    protected static void assertRequestHasParameters(RecordedRequest request, String path, Multimap<String, String> parameters) throws InterruptedException {
        ImmutableMultimap allparams = ImmutableMultimap.builder().putAll(parameters).put((Object)"client_id", (Object)"clientid").put((Object)"api_key", (Object)"apikey").build();
        BaseDigitalOceanMockTest.assertRequestHasAcceptHeader(request);
        Assert.assertEquals((String)request.getRequestLine(), (String)("GET " + path + "?" + Queries.encodeQueryLine((Multimap)allparams) + " HTTP/1.1"));
    }

    protected static void assertRequestHasAcceptHeader(RecordedRequest request) throws InterruptedException {
        Assert.assertEquals((String)request.getHeader("Accept"), (String)"application/json");
    }
}

