/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.features;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.SshKey;
import org.jclouds.digitalocean.internal.BaseDigitalOceanLiveTest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ImageApiLiveTest")
public class KeyPairApiLiveTest
extends BaseDigitalOceanLiveTest {
    private SshKey key;

    public void testCreateKey() throws IOException {
        String publicKey = Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/ssh-rsa.txt"));
        this.key = ((DigitalOceanApi)this.api).getKeyPairApi().create("foo", publicKey);
        Assert.assertNotNull((Object)this.key);
        Assert.assertNotNull((Object)this.key.getId());
        Assert.assertEquals((String)this.key.getName(), (String)"foo");
        Assert.assertNotNull((Object)this.key.getPublicKey());
        Assert.assertEquals((String)this.key.getPublicKey().getAlgorithm(), (String)"RSA");
    }

    @Test(dependsOnMethods={"testCreateKey"})
    public void testListKeys() {
        List keys = ((DigitalOceanApi)this.api).getKeyPairApi().list();
        Assert.assertFalse((boolean)keys.isEmpty(), (String)"SSH key list should not be empty");
    }

    @Test(dependsOnMethods={"testCreateKey"})
    public void testGetKey() {
        Assert.assertNotNull((Object)((DigitalOceanApi)this.api).getKeyPairApi().get(this.key.getId()), (String)"The SSH key should not be null");
    }

    @Test(dependsOnMethods={"testCreateKey"})
    public void testEditKey() throws IOException {
        String newKey = Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/ssh-dsa.txt"));
        SshKey updated = ((DigitalOceanApi)this.api).getKeyPairApi().edit(this.key.getId(), newKey);
        Assert.assertNotNull((Object)updated.getPublicKey(), (String)"The SSH key should have a public key");
        Assert.assertEquals((String)updated.getPublicKey().getAlgorithm(), (String)"DSA");
    }

    @Test(dependsOnMethods={"testListKeys", "testGetKey", "testEditKey"})
    public void testDeleteKey() throws IOException {
        ((DigitalOceanApi)this.api).getKeyPairApi().delete(this.key.getId());
        Assert.assertNull((Object)((DigitalOceanApi)this.api).getKeyPairApi().get(this.key.getId()), (String)"The SSH key should not exist after deleting it");
    }
}

