/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.features;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.DropletCreation;
import org.jclouds.digitalocean.domain.Image;
import org.jclouds.digitalocean.domain.Region;
import org.jclouds.digitalocean.internal.BaseDigitalOceanLiveTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ImageApiLiveTest")
public class ImageApiLiveTest
extends BaseDigitalOceanLiveTest {
    private Image snapshot;
    private DropletCreation droplet;

    protected void initialize() {
        super.initialize();
        this.initializeImageSizeAndRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public void cleanup() {
        try {
            if (this.droplet != null) {
                ((DigitalOceanApi)this.api).getDropletApi().destroy(this.droplet.getId(), true);
            }
        }
        finally {
            if (this.snapshot != null) {
                ((DigitalOceanApi)this.api).getImageApi().delete(this.snapshot.getId());
                Assert.assertFalse((boolean)Iterables.tryFind((Iterable)((DigitalOceanApi)this.api).getImageApi().list(), ImageApiLiveTest.byName(this.snapshot.getName())).isPresent(), (String)"Snapshot should not exist after delete");
            }
        }
    }

    public void testGetImage() {
        Assert.assertNotNull((Object)((DigitalOceanApi)this.api).getImageApi().get(this.defaultImage.getId()), (String)"The image should not be null");
    }

    public void testGetImageNotFound() {
        Assert.assertNull((Object)((DigitalOceanApi)this.api).getImageApi().get(-1));
    }

    public void testTransferImage() {
        this.droplet = ((DigitalOceanApi)this.api).getDropletApi().create("imagetransferdroplet", this.defaultImage.getId(), this.defaultSize.getId(), this.defaultRegion.getId());
        Assert.assertTrue((this.droplet.getId() > 0 ? 1 : 0) != 0, (String)"Created droplet id should be > 0");
        Assert.assertTrue((this.droplet.getEventId() > 0 ? 1 : 0) != 0, (String)"Droplet creation event id should be > 0");
        this.waitForEvent(this.droplet.getEventId());
        int powerOffEvent = ((DigitalOceanApi)this.api).getDropletApi().powerOff(this.droplet.getId());
        this.waitForEvent(powerOffEvent);
        int snapshotEvent = ((DigitalOceanApi)this.api).getDropletApi().snapshot(this.droplet.getId(), "imagetransfersnapshot");
        this.waitForEvent(snapshotEvent);
        this.snapshot = (Image)Iterables.find((Iterable)((DigitalOceanApi)this.api).getImageApi().list(), ImageApiLiveTest.byName("imagetransfersnapshot"));
        Region newRegion = (Region)this.regions.get(1);
        int transferEvent = ((DigitalOceanApi)this.api).getImageApi().transfer(this.snapshot.getId(), newRegion.getId());
        Assert.assertTrue((transferEvent > 0 ? 1 : 0) != 0, (String)"Transfer event id should be > 0");
        this.waitForEvent(transferEvent);
    }

    private static Predicate<Image> byName(final String name) {
        return new Predicate<Image>(){

            public boolean apply(Image input) {
                return input.getName().equals(name);
            }
        };
    }
}

