/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.util.List;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.Droplet;
import org.jclouds.digitalocean.domain.DropletCreation;
import org.jclouds.digitalocean.domain.options.CreateDropletOptions;
import org.jclouds.digitalocean.features.DropletApi;
import org.jclouds.digitalocean.internal.BaseDigitalOceanMockTest;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DropletApiMockTest")
public class DropletApiMockTest
extends BaseDigitalOceanMockTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListDroplets() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/droplets.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            List sizes = dropletApi.list();
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets");
            Assert.assertEquals((int)sizes.size(), (int)1);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/droplet.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            Droplet droplet = dropletApi.get(100823);
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/100823");
            Assert.assertNotNull((Object)droplet);
            Assert.assertNotNull((Object)droplet.getBackups());
            Assert.assertNotNull((Object)droplet.getSnapshots());
            Assert.assertEquals((String)droplet.getName(), (String)"test222");
            Assert.assertEquals((Object)droplet.getStatus(), (Object)Droplet.Status.ACTIVE);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            Droplet droplet = dropletApi.get(100823);
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/100823");
            Assert.assertNull((Object)droplet);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/droplet-creation.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            DropletCreation droplet = dropletApi.create("test", 419, 32, 1);
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/new", (Multimap<String, String>)ImmutableMultimap.of((Object)"name", (Object)"test", (Object)"image_id", (Object)"419", (Object)"size_id", (Object)"32", (Object)"region_id", (Object)"1"));
            Assert.assertNotNull((Object)droplet);
            Assert.assertEquals((String)droplet.getName(), (String)"test");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateDropletWithOptions() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/droplet-creation.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            CreateDropletOptions options = CreateDropletOptions.builder().addSshKeyId(5).addSshKeyId(4).privateNetworking(true).backupsEnabled(false).build();
            DropletCreation droplet = dropletApi.create("test", 419, 32, 1, options);
            ImmutableMultimap.Builder params = ImmutableMultimap.builder();
            params.put((Object)"name", (Object)"test");
            params.put((Object)"image_id", (Object)"419");
            params.put((Object)"size_id", (Object)"32");
            params.put((Object)"region_id", (Object)"1");
            params.put((Object)"ssh_key_ids", (Object)"5,4");
            params.put((Object)"private_networking", (Object)"true");
            params.put((Object)"backups_enabled", (Object)"false");
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/new", (Multimap<String, String>)params.build());
            Assert.assertNotNull((Object)droplet);
            Assert.assertEquals((String)droplet.getName(), (String)"test");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRebootDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.reboot(1);
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/reboot");
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRebootNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.reboot(1);
                Assert.fail((String)"Reboot droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/reboot");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPowerCycleDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.powerCycle(1);
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/power_cycle");
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPowerCycleNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.powerCycle(1);
                Assert.fail((String)"Power cycle droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/power_cycle");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.shutdown(1);
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/shutdown");
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.shutdown(1);
                Assert.fail((String)"Shutdown droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/shutdown");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPowerOffDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.powerOff(1);
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/power_off");
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPowerOffNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.powerOff(1);
                Assert.fail((String)"Power off droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/power_off");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPowerOnDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.powerOn(1);
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/power_on");
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPowerOnNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.powerOn(1);
                Assert.fail((String)"Power on droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/power_on");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResetPasswordForDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.resetPassword(1);
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/password_reset");
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResetPasswordForNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.resetPassword(1);
                Assert.fail((String)"Reset password for droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/password_reset");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResizeDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.resize(1, 3);
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/resize", (Multimap<String, String>)ImmutableMultimap.of((Object)"size_id", (Object)"3"));
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResizeNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.resize(1, 3);
                Assert.fail((String)"Resize droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/resize", (Multimap<String, String>)ImmutableMultimap.of((Object)"size_id", (Object)"3"));
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSnapshotDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.snapshot(1);
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/snapshot");
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSnapshotNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.snapshot(1);
                Assert.fail((String)"Snapshot droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/snapshot");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSnapshotWithNameDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.snapshot(1, "foo");
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/snapshot", (Multimap<String, String>)ImmutableMultimap.of((Object)"name", (Object)"foo"));
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSnapshotWithNameNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.snapshot(1, "foo");
                Assert.fail((String)"Snapshot droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/snapshot", (Multimap<String, String>)ImmutableMultimap.of((Object)"name", (Object)"foo"));
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRestoreDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.restore(1, 3);
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/restore", (Multimap<String, String>)ImmutableMultimap.of((Object)"image_id", (Object)"3"));
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRestoreNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.restore(1, 3);
                Assert.fail((String)"Restore droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/restore", (Multimap<String, String>)ImmutableMultimap.of((Object)"image_id", (Object)"3"));
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRebuildDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.rebuild(1, 3);
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/rebuild", (Multimap<String, String>)ImmutableMultimap.of((Object)"image_id", (Object)"3"));
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRebuildNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.rebuild(1, 3);
                Assert.fail((String)"Rebuild droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/rebuild", (Multimap<String, String>)ImmutableMultimap.of((Object)"image_id", (Object)"3"));
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenameDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.rename(1, "foo");
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/rename", (Multimap<String, String>)ImmutableMultimap.of((Object)"name", (Object)"foo"));
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenameNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.rename(1, "foo");
                Assert.fail((String)"Rename droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/rename", (Multimap<String, String>)ImmutableMultimap.of((Object)"name", (Object)"foo"));
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDestroyDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.destroy(1);
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/destroy");
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDestroyNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.destroy(1);
                Assert.fail((String)"Destroy droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/droplets/1/destroy");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDestroyWithOptionsDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            int event = dropletApi.destroy(1, true);
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/destroy", (Multimap<String, String>)ImmutableMultimap.of((Object)"scrub_data", (Object)"true"));
            Assert.assertTrue((event > 0 ? 1 : 0) != 0);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDestroyWithOptionsNonexistentDroplet() throws Exception {
        MockWebServer server = DropletApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        DropletApi dropletApi = api.getDropletApi();
        try {
            try {
                dropletApi.destroy(1, true);
                Assert.fail((String)"Destroy droplet should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            DropletApiMockTest.assertRequestHasParameters(server.takeRequest(), "/droplets/1/destroy", (Multimap<String, String>)ImmutableMultimap.of((Object)"scrub_data", (Object)"true"));
        }
        finally {
            api.close();
            server.shutdown();
        }
    }
}

