/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.urlhandler;

import com.google.common.io.Files;
import com.google.inject.Module;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.karaf.utils.ServiceHelper;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobUrlHandler
extends AbstractURLStreamHandlerService {
    private static final String BLOBSTORE_TMP_FOLDER = System.getProperty("karaf.data") + File.separatorChar + "blobstore";
    private final Logger logger = LoggerFactory.getLogger(BlobUrlHandler.class);
    private static String SYNTAX = "blob:provider/container/blob?id=?????";
    private List<BlobStore> blobStores = new LinkedList<BlobStore>();
    private ExecutorService executorService = Executors.newCachedThreadPool();

    public URLConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0 || !url.getPath().contains("/")) {
            throw new MalformedURLException("Container / Blob cannot be null or empty. Syntax: " + SYNTAX);
        }
        String[] parts = url.getPath().split("/");
        if (parts.length == 2 && (url.getHost() == null || url.getHost().trim().length() == 0)) {
            throw new MalformedURLException("Provider cannot be null or empty. Syntax: " + SYNTAX);
        }
        this.logger.debug("Blob Protocol URL is: [" + url + "]");
        return new Connection(url);
    }

    private BlobStore createBlobStore(String providerOrApi, String identity, String credential, Iterable<? extends Module> modules, Properties props) {
        ContextBuilder builder = ContextBuilder.newBuilder((String)providerOrApi).credentials(identity, credential).modules(modules).overrides(props);
        BlobStoreContext context = (BlobStoreContext)builder.build(BlobStoreContext.class);
        BlobStore blobStore = context.getBlobStore();
        return blobStore;
    }

    public void setBlobStores(List<BlobStore> blobStores) {
        this.blobStores = blobStores;
    }

    public List<BlobStore> getBlobStores() {
        return this.blobStores;
    }

    public class Connection
    extends URLConnection {
        final String id;
        final String providerOrApi;
        final String containerName;
        final String blobName;
        final URL url;

        public Connection(URL url) {
            super(url);
            this.url = url;
            int index = 0;
            String[] parts = url.getPath().split("/");
            this.providerOrApi = url.getHost() == null || url.getHost().trim().length() == 0 ? parts[index++] : url.getHost();
            this.containerName = parts[index++];
            StringBuilder builder = new StringBuilder();
            builder.append(parts[index++]);
            for (int i = index; i < parts.length; ++i) {
                builder.append("/").append(parts[i]);
            }
            this.blobName = builder.toString();
            Map<String, String> parameters = this.parseUrlParameters(url);
            this.id = parameters != null && parameters.containsKey("id") ? parameters.get("id") : null;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                String userInfo;
                String[] ui;
                BlobStore blobStore = (BlobStore)ServiceHelper.getService(this.id, this.providerOrApi, BlobUrlHandler.this.blobStores);
                if (blobStore == null && this.url.getUserInfo() != null && (ui = (userInfo = this.url.getUserInfo()).split(":")) != null && ui.length == 2) {
                    String identity = ui[0];
                    String credential = ui[1];
                    blobStore = BlobUrlHandler.this.createBlobStore(this.providerOrApi, identity, credential, new LinkedHashSet(), new Properties());
                    BlobUrlHandler.this.blobStores.add(blobStore);
                }
                if (blobStore == null) {
                    throw new IOException("BlobStore service not available for provider " + this.providerOrApi);
                }
                if (!blobStore.containerExists(this.containerName)) {
                    throw new IOException("Container " + this.containerName + " does not exists");
                }
                if (!blobStore.blobExists(this.containerName, this.blobName)) {
                    throw new IOException("Blob " + this.blobName + " does not exists");
                }
                Blob blob = blobStore.getBlob(this.containerName, this.blobName);
                return blob.getPayload().getInput();
            }
            catch (Exception e) {
                throw (IOException)new IOException("Error opening blob protocol url").initCause(e);
            }
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            try {
                final BlobStore blobStore = (BlobStore)ServiceHelper.getService(this.id, this.providerOrApi, BlobUrlHandler.this.blobStores);
                if (!blobStore.containerExists(this.containerName)) {
                    blobStore.createContainerInLocation(null, this.containerName);
                }
                final CountDownLatch readLatch = new CountDownLatch(1);
                final File tmpDir = Files.createTempDir();
                final File tmpBlob = File.createTempFile("blob", null, tmpDir);
                FileOutputStream out = new FileOutputStream(tmpBlob){

                    @Override
                    public void close() throws IOException {
                        readLatch.countDown();
                    }
                };
                Runnable putBlob = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            readLatch.await();
                            Blob blob = blobStore.blobBuilder(Connection.this.blobName).payload(tmpBlob).build();
                            blobStore.putBlob(Connection.this.containerName, blob);
                            tmpBlob.delete();
                            tmpDir.delete();
                        }
                        catch (InterruptedException e) {
                            BlobUrlHandler.this.logger.error("Interrupted while waiting on blob read.", (Throwable)e);
                        }
                    }
                };
                BlobUrlHandler.this.executorService.submit(putBlob);
                return out;
            }
            catch (Exception e) {
                throw (IOException)new IOException("Error opening blob protocol url").initCause(e);
            }
        }

        protected Map<String, String> parseUrlParameters(URL url) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (url != null && url.getQuery() != null) {
                String[] params;
                for (String param : params = url.getQuery().split("&")) {
                    String name = param.split("=")[0];
                    String value = param.split("=")[1];
                    map.put(name, value);
                }
            }
            return map;
        }
    }
}

