/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.table.internal;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.jclouds.karaf.commands.table.BasicShellTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineShellTable<D>
extends BasicShellTable<D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptEngineShellTable.class);
    private final ScriptEngine scriptEngine;

    public ScriptEngineShellTable(ScriptEngineManager scriptEngineManager, String engine) {
        this.scriptEngine = scriptEngineManager.getEngineByName(engine);
        if (this.scriptEngine == null) {
            throw new IllegalStateException("Unable to load script engine " + engine);
        }
    }

    @Override
    public String evaluate(Object obj, String expression) {
        String result = "";
        try {
            this.scriptEngine.put(this.getType(), obj);
            result = String.valueOf(this.scriptEngine.eval(expression));
        }
        catch (Exception exception) {
            LOGGER.warn("Unable to evaluate expression {} due to: {}. Please check your shell confugration", (Object)expression, (Object)exception.getMessage());
            result = "<evalution error - see log>";
        }
        return result;
    }
}

