/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.table.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.jclouds.karaf.commands.table.BasicShellTableFactory;
import org.jclouds.karaf.commands.table.ShellTableFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyShellTableFactory
extends BasicShellTableFactory
implements ShellTableFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyShellTableFactory.class);
    private final String PROPERTIES_FILE_PATH = System.getProperty("karaf.home") + File.separatorChar + "etc" + File.separatorChar + "org.apache.jclouds.shell.cfg";

    public PropertyShellTableFactory() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Properties properties = new Properties();
        File f = new File(this.PROPERTIES_FILE_PATH);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            properties.load(fis);
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = properties.get(key);
                this.getProperties().put(key, value);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load jclouds shell configuration from file.", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

