/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute.completer;

import com.google.common.reflect.TypeToken;
import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;

public class ComputeProviderCompleter
implements Completer {
    private final StringsCompleter delegate = new StringsCompleter();
    private List<? extends ComputeService> computeServices;
    private final boolean displayProvidersWithoutService;

    public ComputeProviderCompleter(boolean displayProvidersWithoutService) {
        this.displayProvidersWithoutService = displayProvidersWithoutService;
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        try {
            if (this.displayProvidersWithoutService) {
                for (ProviderMetadata providerMetadata : Providers.viewableAs((TypeToken)TypeToken.of(ComputeServiceContext.class))) {
                    this.delegate.getStrings().add(providerMetadata.getId());
                }
            } else if (this.computeServices != null) {
                for (ComputeService computeService : this.computeServices) {
                    String id = computeService.getContext().unwrap().getId();
                    if (Providers.withId((String)id) == null) continue;
                    this.delegate.getStrings().add(computeService.getContext().unwrap().getId());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    public List<? extends ComputeService> getComputeServices() {
        return this.computeServices;
    }

    public void setComputeServices(List<? extends ComputeService> computeServices) {
        this.computeServices = computeServices;
    }
}

