/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.karaf.commands.compute.ComputeCommandBase;
import org.jclouds.karaf.services.modules.PropertiesCredentialStore;
import org.jclouds.karaf.utils.EnvHelper;
import org.jclouds.karaf.utils.ServiceHelper;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.ssh.jsch.config.JschSshClientModule;

public abstract class ComputeCommandWithOptions
extends ComputeCommandBase {
    @Option(name="--name", description="The service context name. Used to distinct between multiple service of the same provider/api. Only ")
    protected String name;
    @Option(name="--provider", description="The provider or use.")
    protected String provider;
    @Option(name="--api", description="The api or use.")
    protected String api;
    @Option(name="--identity", description="The identity to use for creating a compute service.")
    protected String identity;
    @Option(name="--credential", description="The credential to use for a compute service.")
    protected String credential;
    @Option(name="--endpoint", description="The endpoint to use for a compute service.")
    protected String endpoint;
    @Option(name="--properties", description="File with properties.")
    protected String propertiesFile;

    @Override
    public List<ComputeService> getComputeServices() {
        if (this.provider == null && this.api == null) {
            return this.computeServices;
        }
        try {
            ComputeService service = this.getComputeService();
            return Collections.singletonList(service);
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    protected ComputeService getComputeService() throws IOException {
        String providerOrApiValue;
        boolean canCreateService;
        String endpointValue;
        String credentialValue;
        String identityValue;
        ComputeService computeService;
        block12: {
            if (this.name == null && this.provider == null && this.api == null && this.computeServices != null && this.computeServices.size() == 1) {
                return (ComputeService)this.computeServices.get(0);
            }
            computeService = null;
            if (this.propertiesFile != null) {
                EnvHelper.loadProperties(new File(this.propertiesFile));
            }
            String providerValue = EnvHelper.getComputeProvider(this.provider);
            String apiValue = EnvHelper.getComputeApi(this.api);
            identityValue = EnvHelper.getComputeIdentity(this.identity);
            credentialValue = EnvHelper.getComputeCredential(providerValue, this.credential);
            endpointValue = EnvHelper.getComputeEndpoint(this.endpoint);
            boolean contextNameProvided = !Strings.isNullOrEmpty((String)this.name);
            canCreateService = (!Strings.isNullOrEmpty((String)providerValue) || !Strings.isNullOrEmpty((String)apiValue)) && !Strings.isNullOrEmpty((String)identityValue) && !Strings.isNullOrEmpty((String)credentialValue);
            providerOrApiValue = !Strings.isNullOrEmpty((String)providerValue) ? providerValue : apiValue;
            try {
                computeService = (ComputeService)ServiceHelper.getService(this.name, providerOrApiValue, this.computeServices);
            }
            catch (Throwable t) {
                if (contextNameProvided) {
                    throw new RuntimeException("Could not find compute service with id:" + this.name);
                }
                if (canCreateService) break block12;
                StringBuilder sb = new StringBuilder();
                sb.append("Insufficient information to create compute service:\n");
                if (providerOrApiValue == null) {
                    sb.append("Missing provider or api. Please specify the --provider / --api options, set the jclouds.provider / jclouds.api properties, or set the JCLOUDS_COMPUTE_PROVIDER / JCLOUDS_COMPUTE_API environment variables.\n");
                }
                if (identityValue == null) {
                    sb.append("Missing identity. Please specify the --identity option, set the jclouds.identity property, or set the JCLOUDS_COMPUTE_IDENTITY environment variable.\n");
                }
                if (credentialValue == null) {
                    sb.append("Missing credential. Please specify the --credential option, set the jclouds.credential property, or set the JCLOUDS_COMPUTE_CREDENTIAL environment variable.\n");
                }
                throw new RuntimeException(sb.toString());
            }
        }
        if (computeService == null && canCreateService) {
            try {
                ContextBuilder builder = ContextBuilder.newBuilder((String)providerOrApiValue).credentials(identityValue, credentialValue).modules((Iterable)ImmutableSet.of((Object)new JschSshClientModule(), (Object)new Log4JLoggingModule(), (Object)((Object)new PropertiesCredentialStore())));
                if (!Strings.isNullOrEmpty((String)endpointValue)) {
                    builder = builder.endpoint(endpointValue);
                }
                computeService = ((ComputeServiceContext)builder.build(ComputeServiceContext.class)).getComputeService();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create service:" + ex.getMessage());
            }
        }
        return computeService;
    }
}

