/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore.completer;

import com.google.common.collect.Multimap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.karaf.commands.support.GenericCompleterSupport;

public abstract class BlobStoreCompleterSupport
extends GenericCompleterSupport<BlobStore, String> {
    @Override
    public String getCacheableKey(BlobStore type) {
        return type.getContext().unwrap().getName();
    }

    protected Set<String> listContainers(BlobStore blobStore) {
        PageSet storageMetadatas;
        LinkedHashSet<String> containers = new LinkedHashSet<String>();
        if (blobStore != null && (storageMetadatas = blobStore.list()) != null && !storageMetadatas.isEmpty()) {
            for (StorageMetadata metadata : storageMetadatas) {
                containers.add(metadata.getName());
            }
        }
        return containers;
    }

    protected Set<String> listBlobs(BlobStore blobStore, String container) {
        PageSet storageMetadatas;
        LinkedHashSet<String> blobs = new LinkedHashSet<String>();
        if (blobStore != null && blobStore.containerExists(container) && (storageMetadatas = blobStore.list(container)) != null && !storageMetadatas.isEmpty()) {
            for (StorageMetadata metadata : storageMetadatas) {
                blobs.add(metadata.getName());
            }
        }
        return blobs;
    }

    @Override
    public void updateOnRemoved(BlobStore blobStore) {
        this.cache.removeAll((Object)blobStore.getContext().unwrap().getId());
    }

    public Multimap<String, String> getCache() {
        return this.cache;
    }

    public void setCache(Multimap<String, String> cache) {
        this.cache = cache;
    }

    @Override
    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    @Override
    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }
}

